/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.adl.legacy;

import java.util.Map;
import org.objectweb.dream.adl.Checker;
import org.objectweb.dream.adl.Resolver;
import org.objectweb.dream.adl.legacy.ComponentNotFoundException;
import org.objectweb.dream.adl.legacy.Legacy;
import org.objectweb.dream.adl.legacy.LegacyContainer;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;

public class LegacyLoader
extends AbstractLoader {
    public static final String CHECKER_ITF_NAME = "checker";
    public static final String RESOLVER_ITF_NAME = "resolver";
    private Checker checkerItf;
    private Resolver resolverItf;

    public Definition load(String name, Map context) throws ADLException {
        Object legacy = context.get("legacy:./");
        if (legacy == null) {
            throw new ADLException("Unable to find legacy component in context", null);
        }
        Definition d = this.clientLoader.load(name, context);
        this.checkNode((Node)((Object)d), legacy, "legacy:./", context);
        return d;
    }

    private void checkNode(Node node, Object legacy, String path, Map context) throws ADLException {
        if (legacy != null) {
            this.checkerItf.check(legacy, node);
            node.astSetDecoration("legacy", legacy);
        }
        if (node instanceof ComponentContainer) {
            ComponentContainer container = (ComponentContainer)((Object)node);
            Component[] tab = container.getComponents();
            for (int i = 0; i < tab.length; ++i) {
                Legacy l;
                Component subComponent = tab[i];
                String componentPath = path.endsWith("/") ? path + subComponent.getName() : path + "/" + subComponent.getName();
                Object subLegacy = null;
                if (subComponent instanceof LegacyContainer && (l = ((LegacyContainer)((Object)subComponent)).getLegacy()) != null && (subLegacy = (Object)context.get(componentPath)) == null && legacy != null) {
                    if ("mandatory".equals(l.getContingency())) {
                        try {
                            subLegacy = this.resolverItf.resolve(legacy, subComponent.getName(), context);
                        }
                        catch (ComponentNotFoundException e) {
                            throw new ADLException("Unable to find mandatory legacy component.", (Node)((Object)subComponent), e);
                        }
                    }
                    if ("optionnal".equals(l.getContingency())) {
                        try {
                            subLegacy = this.resolverItf.resolve(legacy, subComponent.getName(), context);
                        }
                        catch (ComponentNotFoundException e) {
                            break;
                        }
                    }
                }
                this.checkNode((Node)((Object)subComponent), subLegacy, componentPath, context);
            }
        }
    }

    public String[] listFc() {
        return new String[]{"client-loader", CHECKER_ITF_NAME, RESOLVER_ITF_NAME};
    }

    public Object lookupFc(String s) {
        if (CHECKER_ITF_NAME.equals(s)) {
            return this.checkerItf;
        }
        if (RESOLVER_ITF_NAME.equals(s)) {
            return this.resolverItf;
        }
        return super.lookupFc(s);
    }

    public void bindFc(String s, Object o) {
        if (CHECKER_ITF_NAME.equals(s)) {
            this.checkerItf = (Checker)o;
        } else if (RESOLVER_ITF_NAME.equals(s)) {
            this.resolverItf = (Resolver)o;
        } else {
            super.bindFc(s, o);
        }
    }

    public void unbindFc(String s) {
        if (CHECKER_ITF_NAME.equals(s)) {
            this.checkerItf = null;
        } else if (RESOLVER_ITF_NAME.equals(s)) {
            this.resolverItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

