/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.objectweb.dream.PushException;
import org.objectweb.dream.PushPushDreamComponent;
import org.objectweb.dream.channel.AddIPChannelAttributeController;
import org.objectweb.dream.channel.IPChannelDestinationChunk;
import org.objectweb.dream.channel.IPChannelSourceChunk;
import org.objectweb.dream.message.ChunkAlreadyExistsException;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicAddIPChannelSourceChunkImpl
extends PushPushDreamComponent
implements AddIPChannelAttributeController {
    protected MessageManager messageManagerItf;
    protected String chunkName = "IPChannelSource";
    protected InetAddress inetAddress;
    protected int port;

    public void push(Message message, Map context) throws PushException {
        IPChannelSourceChunk chunk = (IPChannelSourceChunk)message.getChunk(this.chunkName);
        if (chunk == null) {
            if (message instanceof ExtensibleMessage) {
                chunk = (IPChannelSourceChunk)this.messageManagerItf.createChunk(IPChannelSourceChunk.TYPE);
                try {
                    ((ExtensibleMessage)message).addChunk(this.chunkName, IPChannelDestinationChunk.TYPE, chunk);
                }
                catch (ChunkAlreadyExistsException e) {}
            } else {
                this.logger.log(BasicLevel.ERROR, (Object)"Invalid message : not extensible");
                throw new InternalError("Invalid message : not extensible");
            }
        }
        chunk.setChannelSourceAddr(this.inetAddress);
        chunk.setChannelSourcePort(this.port);
        this.outPushItf.push(message, context);
    }

    public String getChunkName() {
        return this.chunkName;
    }

    public void setChunkName(String chunkName) {
        this.chunkName = chunkName;
    }

    public String getInetAddress() {
        return this.inetAddress.getCanonicalHostName();
    }

    public void setInetAddress(String inetAddress) throws UnknownHostException {
        this.inetAddress = InetAddress.getByName(inetAddress);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String[] listFc() {
        return new String[]{"out-push", "message-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        super.startFc();
        if (this.inetAddress == null) {
            try {
                this.inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new IllegalLifeCycleException("Unable to get local inet address : " + e.getLocalizedMessage());
            }
        }
    }
}

