/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import org.objectweb.dream.InitializationException;
import org.objectweb.dream.channel.AbstractTCPChannelInImpl;
import org.objectweb.dream.control.activity.Util;
import org.objectweb.dream.control.activity.task.AbstractTask;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.message.Message;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicTCPChannelInImpl
extends AbstractTCPChannelInImpl {
    protected ServerSocket listen;
    protected Task channelInTask = new ChannelInTask();

    protected void initComponent(Component componentItf) throws InitializationException {
        super.initComponent(componentItf);
        try {
            Util.addTask(componentItf, this.channelInTask, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new InitializationException(e, componentItf, "Can't add task");
        }
    }

    public synchronized void stopFc() throws IllegalLifeCycleException {
        try {
            this.listen.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listen = null;
        super.stopFc();
    }

    protected class ChannelInTask
    extends AbstractTask {
        public ChannelInTask() {
            super("ChannelInTask");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Object hints) throws InterruptedException {
            ObjectInputStream ois = null;
            try {
                Socket socket;
                if (BasicTCPChannelInImpl.this.listen == null || BasicTCPChannelInImpl.this.listen.isClosed()) {
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"ServerSocket closed, create new one");
                    BasicTCPChannelInImpl.this.listen = BasicTCPChannelInImpl.this.createServerSocket(BasicTCPChannelInImpl.this.portNum);
                }
                try {
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"waiting connection");
                    socket = BasicTCPChannelInImpl.this.listen.accept();
                }
                catch (SocketException ex) {
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)ex);
                    return EXECUTE_AGAIN;
                }
                BasicTCPChannelInImpl.this.setSocketOption(socket);
                BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"connected");
                try {
                    ois = new ObjectInputStream(socket.getInputStream());
                    Message msg = BasicTCPChannelInImpl.this.messageCodecItf.decode(ois);
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"msg received");
                    BasicTCPChannelInImpl.this.outPushItf.push(msg, null);
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)"send ack");
                    BasicTCPChannelInImpl.this.sendAck(socket);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        ois.close();
                    }
                    catch (Exception exc) {
                        BasicTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)exc);
                    }
                    ois = null;
                    try {
                        socket.close();
                    }
                    catch (Exception exc) {
                        BasicTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)exc);
                    }
                    socket = null;
                    throw throwable;
                }
                try {
                    ois.close();
                }
                catch (Exception exc) {
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)exc);
                }
                ois = null;
                try {
                    socket.close();
                }
                catch (Exception exc) {
                    BasicTCPChannelInImpl.this.logger.log(BasicLevel.WARN, (Object)exc);
                }
                socket = null;
                {
                }
            }
            catch (ConnectException e) {
                BasicTCPChannelInImpl.this.logger.log(BasicLevel.DEBUG, (Object)e);
            }
            catch (IOException exc) {
                BasicTCPChannelInImpl.this.logger.log(BasicLevel.ERROR, (Object)"Output/Input Stream failed", (Throwable)exc);
            }
            catch (Exception exc) {
                BasicTCPChannelInImpl.this.logger.log(BasicLevel.ERROR, (Object)"Exception during ", (Throwable)exc);
            }
            return EXECUTE_AGAIN;
        }
    }
}

