/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.channel.IPSocketManager;
import org.objectweb.dream.channel.SocketManager;
import org.objectweb.dream.channel.SocketState;
import org.objectweb.dream.channel.StaticSocketManagerAttributeController;
import org.objectweb.dream.message.Message;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class IPStaticSocketManagerImpl
extends AbstractComponent
implements SocketManager,
StaticSocketManagerAttributeController {
    protected boolean destinationChanged = false;
    protected boolean inUse = false;
    protected SocketState currentSocket;
    protected InetAddress destinationAddress;
    protected int destinationPort;
    protected IPSocketManager delegateSocketManagerItf;

    public synchronized SocketState getSocket(Message message) throws IOException {
        if (this.inUse) {
            throw new IOException("Socket is already in use.");
        }
        this.inUse = true;
        if (this.currentSocket == null || this.currentSocket.isClosed() || this.destinationChanged) {
            if (this.currentSocket != null) {
                this.delegateSocketManagerItf.releaseSocket(this.currentSocket);
            }
            this.currentSocket = this.delegateSocketManagerItf.getSocket(this.destinationAddress, this.destinationPort);
            this.destinationChanged = false;
        }
        return this.currentSocket;
    }

    public synchronized void releaseSocket(SocketState socketState) {
        if (socketState != this.currentSocket) {
            throw new IllegalArgumentException("The given SocketState is not the last returned SocketState");
        }
        if (this.destinationChanged) {
            this.delegateSocketManagerItf.releaseSocket(socketState);
            this.currentSocket = null;
            this.destinationChanged = false;
        }
        this.inUse = false;
    }

    public String getDestinationHostname() {
        return this.destinationAddress.getCanonicalHostName();
    }

    public void setDestinationHostname(String hostname) throws UnknownHostException {
        this.destinationAddress = InetAddress.getByName(hostname);
        this.destinationChanged = true;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public void setDestinationPort(int port) {
        if (this.destinationPort != port) {
            this.destinationPort = port;
            this.destinationChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFc() throws IllegalLifeCycleException {
        IPStaticSocketManagerImpl iPStaticSocketManagerImpl = this;
        synchronized (iPStaticSocketManagerImpl) {
            this.currentSocket.close();
            this.currentSocket = null;
        }
        super.stopFc();
    }

    public String[] listFc() {
        return new String[]{"ip-socket-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("ip-socket-manager")) {
            this.delegateSocketManagerItf = (IPSocketManager)serverItf;
        }
    }
}

