/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.activity.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.control.activity.task.IllegalTaskException;
import org.objectweb.dream.control.activity.task.NoSuchTaskException;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.control.activity.task.TaskController;
import org.objectweb.dream.control.activity.task.TaskManagerController;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class BasicTaskControllerMixin
implements TaskController {
    protected Map taskRegistrationHints;
    protected Map taskControls;
    public Logger _this_weaveableTCLogger;
    public BindingController _this_weaveableBC;

    private BasicTaskControllerMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this._super_initFcController(ic);
        this.taskRegistrationHints = Collections.synchronizedMap(new HashMap());
        this.taskControls = Collections.synchronizedMap(new HashMap());
    }

    public Task[] getTasks() {
        Task[] tasks = new Task[this.taskRegistrationHints.keySet().size()];
        return this.taskRegistrationHints.keySet().toArray(tasks);
    }

    public void addTask(Task task, Map hints) throws IllegalTaskException {
        if (this.taskRegistrationHints.containsKey(task)) {
            throw new IllegalTaskException(task, "The given task has already been added in the task controller", null);
        }
        this.taskRegistrationHints.put(task, hints);
    }

    public Object getTaskControl(Task task) throws NoSuchTaskException {
        if (!this.taskRegistrationHints.containsKey(task)) {
            throw new NoSuchTaskException(task);
        }
        return this.taskControls.get(task);
    }

    public void removeTask(Task task) throws NoSuchTaskException, IllegalTaskException {
        if (!this.taskRegistrationHints.containsKey(task)) {
            throw new NoSuchTaskException(task);
        }
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"remove a task");
        try {
            this.taskRegistrationHints.remove(task);
        }
        catch (Exception e) {
            throw new IllegalTaskException(task, "Unable to unregister task", e);
        }
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"task removed");
    }

    private TaskManagerController getTaskManagerBinding() throws IllegalTaskException {
        try {
            return (TaskManagerController)this._this_weaveableBC.lookupFc("task-manager");
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalTaskException(null, "This component has no task-manager client interface", null);
        }
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

