/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.activity.task.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.dream.control.activity.task.TaskLifeCycleController;
import org.objectweb.dream.control.activity.task.TaskStoppedListener;
import org.objectweb.dream.control.activity.task.thread.AbstractThreadTask;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolAttributeController;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolController;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolOverflowException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BasicThreadPoolTask
extends AbstractThreadTask
implements TaskLifeCycleController,
ThreadPoolController,
ThreadPoolAttributeController {
    Object threadTaskLock = new Object();
    long waitTimeout = 2000L;
    int capacity = 0;
    LinkedList activeThreads = new LinkedList();
    Set waitingThreads = new HashSet();
    List taskStoppedListeners = new ArrayList();
    boolean stopping;

    protected boolean isExecuting() {
        return ((PoolThread)Thread.currentThread()).executing;
    }

    protected void setExecuting(boolean b) {
        ((PoolThread)Thread.currentThread()).executing = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbActiveThread() {
        Object object = this.threadTaskLock;
        synchronized (object) {
            return this.activeThreads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreads(int i) throws ThreadPoolOverflowException, IllegalLifeCycleException {
        Object object = this.threadTaskLock;
        synchronized (object) {
            if (this.getFcState() == "STOPPED") {
                throw new IllegalLifeCycleException("Can't add thread in the stopped state.");
            }
            if (this.getNbActiveThread() + i > this.getCapacity()) {
                throw new ThreadPoolOverflowException("Can't add Thread in pool due to capacity limitation");
            }
            for (int j = 0; j < i; ++j) {
                PoolThread t = null;
                Collection collection = this.waitingThreads;
                synchronized (collection) {
                    if (!this.waitingThreads.isEmpty()) {
                        Iterator iterator = this.waitingThreads.iterator();
                        t = (PoolThread)iterator.next();
                        iterator.remove();
                        Object object2 = this.activeThreads;
                        synchronized (object2) {
                            this.activeThreads.add(t);
                        }
                        object2 = t;
                        synchronized (object2) {
                            t.revive = true;
                            t.notify();
                        }
                    }
                }
                this.logger.log(BasicLevel.DEBUG, (Object)"Creates a new thread task");
                t = new PoolThread();
                collection = this.activeThreads;
                synchronized (collection) {
                    this.activeThreads.add(t);
                }
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThreads(int i) throws IllegalLifeCycleException {
        Object object = this.threadTaskLock;
        synchronized (object) {
            if (this.getFcState() == "STOPPED") {
                throw new IllegalLifeCycleException("Can't remove thread in the stopped state.");
            }
            for (int j = 0; j < i; ++j) {
                PoolThread t;
                LinkedList linkedList = this.activeThreads;
                synchronized (linkedList) {
                    t = (PoolThread)this.activeThreads.removeFirst();
                }
                this.logger.log(BasicLevel.DEBUG, (Object)"Stop a thread task");
                t.executing = false;
                t.interrupt();
            }
        }
    }

    public void setCapacity(int i) {
        this.capacity = i;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(long millis) {
        this.waitTimeout = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFc() throws IllegalLifeCycleException {
        if (this.getFcState() == "STARTED") {
            return;
        }
        Object object = this.threadTaskLock;
        synchronized (object) {
            super.startFc();
            this.stopping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFc() throws IllegalLifeCycleException {
        if (this.getFcState() == "STOPPED") {
            return;
        }
        Object object = this.threadTaskLock;
        synchronized (object) {
            boolean noActiveThread;
            this.logger.log(BasicLevel.DEBUG, (Object)"Stopping thread pool task");
            this.stopping = true;
            this.interruptPool();
            LinkedList linkedList = this.activeThreads;
            synchronized (linkedList) {
                noActiveThread = this.activeThreads.isEmpty();
            }
            while (!noActiveThread) {
                try {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Join threads of the task");
                    this.threadTaskLock.wait();
                }
                catch (InterruptedException e) {
                    throw new ChainedIllegalLifeCycleException(e, this.weaveableC, "Interrupted while waiting for the end of the thread pool.");
                }
                linkedList = this.activeThreads;
                synchronized (linkedList) {
                    noActiveThread = this.activeThreads.isEmpty();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncStop(TaskStoppedListener listener) {
        if (this.getFcState() == "STOPPED") {
            return;
        }
        Object object = this.threadTaskLock;
        synchronized (object) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Stopping asynchronously thread pool task");
            this.stopping = true;
            this.interruptPool();
            this.taskStoppedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptPool() {
        PoolThread thread;
        Iterator iter;
        this.logger.log(BasicLevel.DEBUG, (Object)"Interrupting threads of the task");
        Collection collection = this.activeThreads;
        synchronized (collection) {
            iter = this.activeThreads.iterator();
            while (iter.hasNext()) {
                thread = (PoolThread)iter.next();
                thread.executing = false;
                thread.interrupt();
            }
        }
        collection = this.waitingThreads;
        synchronized (collection) {
            iter = this.waitingThreads.iterator();
            while (iter.hasNext()) {
                thread = (PoolThread)iter.next();
                thread.executing = false;
                thread.interrupt();
            }
        }
    }

    static /* synthetic */ Logger access$100(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$200(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$300(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$400(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ void access$501(BasicThreadPoolTask x0) throws IllegalLifeCycleException {
        super.stopFc();
    }

    static /* synthetic */ Logger access$600(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$700(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$800(BasicThreadPoolTask x0) {
        return x0.logger;
    }

    private class PoolThread
    extends Thread {
        boolean executing = true;
        boolean revive;

        private PoolThread() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

