/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.logger;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.dream.control.logger.Loggable;
import org.objectweb.dream.control.logger.LoggerController;
import org.objectweb.dream.control.logger.LoggerControllerRegister;
import org.objectweb.dream.control.logger.Util;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;

public abstract class BasicLoggerControllerMixin
implements LoggerController,
LoggerControllerRegister,
Initializable {
    String baseName;
    Map registrations;
    Map loggers;

    public void initialize(Tree args) throws Exception {
        this._super_initialize(args);
        for (int i = 0; i < args.getSize(); ++i) {
            Tree arg = args.getSubTree(i);
            if (arg.getSize() != 2 || !arg.getSubTree(0).equals("monolog-conf-file")) continue;
            String monologConfFile = arg.getSubTree(1).toString();
            if (Monolog.monologFactory != Monolog.getDefaultMonologFactory()) continue;
            Monolog.getMonologFactory(monologConfFile);
        }
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this._super_initFcController(ic);
        this.baseName = Util.getNextUnnamedBaseName();
        this.registrations = new HashMap();
        this.loggers = new HashMap();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
        this.baseNameChanged();
    }

    public Level getLoggerLevel(String loggerName) {
        Logger l = (Logger)this.loggers.get(loggerName);
        if (l == null) {
            return null;
        }
        return l.getCurrentLevel();
    }

    public void setLoggerLevel(String loggerName, Level level) {
        Logger l = (Logger)this.loggers.get(loggerName);
        if (l == null) {
            return;
        }
        l.setLevel(level);
    }

    public void register(String loggerName, Loggable loggable) {
        HashSet<Loggable> s = (HashSet<Loggable>)this.registrations.get(loggerName);
        if (s == null) {
            s = new HashSet<Loggable>();
            this.registrations.put(loggerName, s);
        }
        s.add(loggable);
        this.giveLogger(loggerName, loggable);
    }

    public void unregiser(String loggerName, Loggable loggable) {
        Set s = (Set)this.registrations.get(loggerName);
        if (s == null) {
            return;
        }
        s.remove(loggable);
        if (s.isEmpty()) {
            this.registrations.remove(loggerName);
            this.loggers.remove(loggerName);
        }
    }

    void baseNameChanged() {
        this.loggers.clear();
        Iterator iter = this.registrations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String loggerName = (String)entry.getKey();
            Set loggables = (Set)entry.getValue();
            Iterator iter2 = loggables.iterator();
            while (iter2.hasNext()) {
                Loggable loggable = (Loggable)iter2.next();
                this.giveLogger(loggerName, loggable);
            }
        }
    }

    void giveLogger(String loggerName, Loggable loggable) {
        Logger logger = (Logger)this.loggers.get(loggerName);
        if (logger == null) {
            String name = loggerName == null ? this.baseName : this.baseName + "." + loggerName;
            logger = Monolog.monologFactory.getLogger(name);
            this.loggers.put(loggerName, logger);
        }
        loggable.setLogger(loggerName, logger);
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;

    public abstract void _super_initialize(Tree var1) throws Exception;
}

