/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message.manager;

import java.util.Iterator;
import org.objectweb.dream.message.AbstractExtensibleMessage;
import org.objectweb.dream.message.BasicChunkType;
import org.objectweb.dream.message.BasicExtensibleMessage;
import org.objectweb.dream.message.BasicExtensibleMessageNC;
import org.objectweb.dream.message.Chunk;
import org.objectweb.dream.message.ChunkAlreadyExistsException;
import org.objectweb.dream.message.ChunkType;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageAlreadyExistException;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.message.MessageTypeNC;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.message.manager.MessageManagerAttributeController;
import org.objectweb.dream.message.manager.UnknownChunkTypeError;

public class BasicMessageManagerImpl
implements MessageManager,
MessageManagerAttributeController {
    short id = (short)-1;

    public Message createMessage(MessageType type) throws UnknownChunkTypeError {
        Iterator iterator;
        BasicExtensibleMessage msg;
        if (type instanceof MessageTypeNC) {
            BasicExtensibleMessageNC message = new BasicExtensibleMessageNC(this.id);
            msg = message;
            MessageTypeNC typeNC = (MessageTypeNC)type;
            iterator = typeNC.getSubMessageNamesIterator();
            while (iterator.hasNext()) {
                String msgName = (String)iterator.next();
                MessageType t = typeNC.getSubMessageType(msgName);
                try {
                    message.addSubMessage(msgName, this.createMessage(t));
                }
                catch (MessageAlreadyExistException e) {}
            }
            iterator = typeNC.getUnnamedSubMessageTypesIterator();
        } else {
            msg = new BasicExtensibleMessage(this.id);
            iterator = type.getSubMessageTypesIterator();
        }
        while (iterator.hasNext()) {
            MessageType t = (MessageType)iterator.next();
            msg.addSubMessage(this.createMessage(t));
        }
        iterator = type.getChunkNamesIterator();
        while (iterator.hasNext()) {
            String chunkName = (String)iterator.next();
            ChunkType t = type.getChunkType(chunkName);
            try {
                msg.addChunk(chunkName, t, this.createChunk(t));
            }
            catch (ChunkAlreadyExistsException e) {}
        }
        return msg;
    }

    public void deleteMessage(Message message) {
        ((AbstractExtensibleMessage)message).decrementReferenceCounter();
    }

    public Message duplicateMessage(Message message, boolean clone) {
        if (clone) {
            Message newInstance = this.createMessage(message.getMessageType());
            message.transfertChunkStates(newInstance);
            return newInstance;
        }
        ((AbstractExtensibleMessage)message).incrementReferenceCounter();
        return message;
    }

    public Object createChunk(ChunkType type) throws UnknownChunkTypeError {
        if (type instanceof BasicChunkType) {
            try {
                Chunk chunk = (Chunk)((BasicChunkType)type).getChunkImpl().newInstance();
                chunk.setMessageManagerId(this.id);
                return chunk;
            }
            catch (Exception e) {
                throw new InternalError("Unable to instanciate chunk implementation : " + e.getLocalizedMessage());
            }
        }
        throw new UnknownChunkTypeError(type);
    }

    public void deleteChunk(Object chunk) {
    }

    public Object duplicateChunk(Object chunk, boolean clone) {
        if (chunk instanceof Chunk) {
            Chunk c = (Chunk)chunk;
            Chunk newInstance = (Chunk)this.createChunk(c.getType());
            c.transfertState(newInstance);
            return c;
        }
        throw new InternalError("Unable to duplicate chunk : " + chunk);
    }

    public short getMessageManagerId() {
        return this.id;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }
}

