/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message.manager;

import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.message.AbstractNonExtensibleMessage;
import org.objectweb.dream.message.ChunkType;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.message.manager.PoolNonExtensibleMessageManagerAttributeController;
import org.objectweb.dream.message.manager.UnknownChunkTypeError;
import org.objectweb.dream.util.EmptyStringArray;
import org.objectweb.dream.util.Error;
import org.objectweb.util.monolog.api.BasicLevel;

public class PoolNonExtensibleMessageManagerImpl
extends AbstractComponent
implements MessageManager,
PoolNonExtensibleMessageManagerAttributeController {
    private Message[] pool;
    private int elementCount = 0;
    private int capacity;
    private short id;
    private String className = null;
    private Class messageClass;

    public synchronized Message createMessage(MessageType type) throws UnknownChunkTypeError {
        if (this.elementCount == 0) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Create new message");
            Message m = null;
            try {
                m = (Message)this.messageClass.newInstance();
            }
            catch (Exception e) {
                Error.bug(this.logger, e);
            }
            m.setMessageManagerId(this.id);
            ((AbstractNonExtensibleMessage)m).incrementReferenceCounter();
            return m;
        }
        --this.elementCount;
        Message message = this.pool[this.elementCount];
        this.pool[this.elementCount] = null;
        ((AbstractNonExtensibleMessage)message).incrementReferenceCounter();
        return message;
    }

    public synchronized void deleteMessage(Message message) {
        if (message != null && ((AbstractNonExtensibleMessage)message).decrementReferenceCounter()) {
            message.recycle();
            if (this.elementCount == this.pool.length || message == null) {
                return;
            }
            this.pool[this.elementCount] = message;
            ++this.elementCount;
        }
    }

    public Message duplicateMessage(Message message, boolean clone) {
        if (clone) {
            Message newInstace = this.createMessage(null);
            message.transfertChunkStates(newInstace);
            return newInstace;
        }
        ((AbstractNonExtensibleMessage)message).incrementReferenceCounter();
        return message;
    }

    public Object createChunk(ChunkType type) throws UnknownChunkTypeError {
        Error.error("This message manager handle only inextensible message", this.logger);
        return null;
    }

    public void deleteChunk(Object chunk) {
        Error.error("This message manager handle only inextensible message", this.logger);
    }

    public Object duplicateChunk(Object chunk, boolean clone) {
        Error.error("This message manager handle only inextensible message", this.logger);
        return null;
    }

    public short getMessageManagerId() {
        return this.id;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.pool = new Message[capacity];
        this.elementCount = 0;
    }

    public String getMessageClassName() {
        return this.className;
    }

    public void setMessageClassName(String name) {
        if (this.className != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("This message manager already manages messaeges of class " + this.className));
            new IllegalArgumentException("This message manager already manages messaeges of class " + this.className);
        }
        this.className = name;
        try {
            this.messageClass = Class.forName(name);
            this.messageClass.newInstance();
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Invalid class " + this.className), (Throwable)e);
            new IllegalArgumentException("Invalid class " + this.className);
        }
    }

    public String[] listFc() {
        return EmptyStringArray.EMPTY_STRING_ARRAY;
    }
}

