/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;

public class Launcher {
    private Launcher() {
    }

    public static void main(String[] args) throws Exception {
        String[] pargs = Launcher.parseArgs(args);
        Object comp = Launcher.createComponent(pargs);
        if (comp instanceof Component) {
            LifeCycleController lc = null;
            try {
                lc = Fractal.getLifeCycleController((Component)comp);
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            if (lc != null) {
                lc.startFc();
            }
            Runnable r = null;
            try {
                r = (Runnable)((Component)comp).getFcInterface(pargs[2]);
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            if (r != null) {
                r.run();
            }
        } else {
            if (comp instanceof LifeCycleController) {
                ((LifeCycleController)comp).startFc();
            }
            if (comp instanceof Runnable) {
                ((Runnable)comp).run();
            }
        }
    }

    private static Object createComponent(String[] pargs) throws Exception {
        if (pargs[0].equals("-java")) {
            Factory f = FactoryFactory.getFactory("org.objectweb.fractal.adl.JavaBackend");
            return ((Map)f.newComponent(pargs[1], new HashMap())).get(pargs[2]);
        }
        Factory f = FactoryFactory.getFactory("org.objectweb.fractal.adl.FractalBackend");
        return f.newComponent(pargs[1], new HashMap());
    }

    private static String[] parseArgs(String[] args) {
        if (args.length < 1 || args.length > 3) {
            Launcher.parseError();
        }
        String[] result = new String[3];
        if (args[0].equals("-java") || args[0].equals("-fractal")) {
            if (args.length < 2) {
                Launcher.parseError();
            }
            result[0] = args[0];
            result[1] = args[1];
            result[2] = args.length == 3 ? args[2] : "run";
        } else {
            result[0] = "-java";
            result[1] = args[0];
            result[2] = args.length >= 2 ? args[1] : "run";
        }
        return result;
    }

    private static void parseError() {
        System.out.println("Usage: Launcher [-java|-fractal] <definition> [ <itf> ]");
        System.out.print("where <definition> is the name of the component to be ");
        System.out.print("instantiated and started,\nand <itf> is the name of ");
        System.out.println("its Runnable interface, if it has one");
        System.exit(1);
    }
}

