/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;

public class AttributeLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        boolean extend = false;
        if (d instanceof ComponentDefinition) {
            extend = ((ComponentDefinition)d).getExtends() != null;
        }
        this.checkNode(d, extend, context);
        return d;
    }

    private void checkNode(Object node, boolean extend, Map context) throws ADLException {
        if (node instanceof AttributesContainer) {
            this.checkAttributesContainer((AttributesContainer)node, extend, context);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], extend, context);
            }
        }
    }

    private void checkAttributesContainer(AttributesContainer container, boolean extend, Map context) throws ADLException {
        Attributes attrs = container.getAttributes();
        if (attrs != null) {
            Class<?> c;
            String signature = attrs.getSignature();
            if (signature == null) {
                if (!extend) {
                    throw new ADLException("Signature missing", (Node)((Object)attrs));
                }
                return;
            }
            try {
                c = this.getClassLoader(context).loadClass(signature);
            }
            catch (ClassNotFoundException e) {
                throw new ADLException("Invalid signature '" + signature + "'", (Node)((Object)attrs), e);
            }
            Attribute[] attributes = attrs.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Method getter;
                String attrName = attributes[i].getName();
                String attrValue = attributes[i].getValue();
                if (attrName == null) {
                    throw new ADLException("Attribute name missing", (Node)((Object)attributes[i]));
                }
                if (attrValue == null) {
                    throw new ADLException("Attribute value missing", (Node)((Object)attributes[i]));
                }
                String getterName = "get" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
                try {
                    getter = c.getMethod(getterName, new Class[0]);
                }
                catch (Exception e) {
                    throw new ADLException("No such attribute", (Node)((Object)attributes[i]), e);
                }
                Class<?> attrType = getter.getReturnType();
                if (attrType.isPrimitive()) {
                    if (attrType.equals(Integer.TYPE)) {
                        try {
                            Integer.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad integer value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Long.TYPE)) {
                        try {
                            Long.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad long value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Float.TYPE)) {
                        try {
                            Float.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad float value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Double.TYPE)) {
                        try {
                            Double.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad double value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Byte.TYPE)) {
                        try {
                            Byte.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad byte value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Character.TYPE)) {
                        if (attrValue.length() == 1) continue;
                        throw new ADLException("Bad char value: " + attrValue, (Node)((Object)attributes[i]));
                    }
                    if (attrType.equals(Short.TYPE)) {
                        try {
                            Short.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad short value: " + attrValue, (Node)((Object)attributes[i]));
                        }
                    }
                    if (attrType.equals(Boolean.TYPE)) {
                        if (attrValue.equals("true") || attrValue.equals("false")) continue;
                        throw new ADLException("Bad boolean value: " + attrValue, (Node)((Object)attributes[i]));
                    }
                    throw new ADLException("Unexpected case", (Node)((Object)attributes[i]));
                }
                if (attrType == String.class) continue;
                throw new ADLException("Unsupported attribute type: " + attrType, (Node)((Object)attributes[i]));
            }
        }
    }
}

