/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.bindings.TypeInterface_Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

public class UnboundInterfaceChecker
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkDefinition(d);
        return d;
    }

    private void checkDefinition(Definition definition) throws ADLException {
        HashMap unboundMandatoryClientInterfacesMap = new HashMap();
        this.checkNode(definition, unboundMandatoryClientInterfacesMap);
        for (Map.Entry entry : unboundMandatoryClientInterfacesMap.entrySet()) {
            Component comp = (Component)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            for (TypeInterface_Node itfNode : list) {
                System.err.println("Warning: Mandatory client interface '" + comp.getName() + '.' + itfNode.itf.getName() + " is not bound (" + itfNode.node.astGetSource() + ")");
            }
        }
    }

    private void checkNode(Object node, Map unboundMandatoryClientInterfacesMap) throws ADLException {
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            if (comps.length > 0) {
                int i;
                HashSet<String> bindingClientsSet = new HashSet<String>();
                if (node instanceof BindingContainer) {
                    Binding[] bindings = ((BindingContainer)node).getBindings();
                    for (i = 0; i < bindings.length; ++i) {
                        bindingClientsSet.add(bindings[i].getFrom());
                    }
                }
                for (int i2 = 0; i2 < comps.length; ++i2) {
                    Component comp = comps[i2];
                    Node compNode = (Node)((Object)comp);
                    ArrayList<TypeInterface_Node> unboundMandatoryClientInterfacesList = null;
                    if (compNode.astGetDecoration("areMandatoryClientInterfacesChecked") == null) {
                        compNode.astSetDecoration("areMandatoryClientInterfacesChecked", "yes");
                        if (!(comp instanceof InterfaceContainer)) continue;
                        Interface[] interfaces = ((InterfaceContainer)((Object)comp)).getInterfaces();
                        for (int j = 0; j < interfaces.length; ++j) {
                            TypeInterface itf = (TypeInterface)interfaces[j];
                            if (!"client".equals(itf.getRole()) || !this.isMandatoryInterface(itf) || this.isBoundInterface(bindingClientsSet, comp.getName(), itf)) continue;
                            if (unboundMandatoryClientInterfacesList == null) {
                                unboundMandatoryClientInterfacesList = new ArrayList<TypeInterface_Node>();
                                unboundMandatoryClientInterfacesMap.put(comp, unboundMandatoryClientInterfacesList);
                            }
                            unboundMandatoryClientInterfacesList.add(new TypeInterface_Node(itf, (Node)node));
                        }
                        continue;
                    }
                    unboundMandatoryClientInterfacesList = (ArrayList<TypeInterface_Node>)unboundMandatoryClientInterfacesMap.get(comp);
                    if (unboundMandatoryClientInterfacesList == null) continue;
                    Iterator iter = unboundMandatoryClientInterfacesList.iterator();
                    while (iter.hasNext()) {
                        TypeInterface_Node itfNode = (TypeInterface_Node)iter.next();
                        if (!this.isBoundInterface(bindingClientsSet, comp.getName(), itfNode.itf)) continue;
                        iter.remove();
                    }
                    if (unboundMandatoryClientInterfacesList.size() != 0) continue;
                    unboundMandatoryClientInterfacesMap.remove(comp);
                }
                if (node instanceof InterfaceContainer) {
                    Interface[] interfaces = ((InterfaceContainer)node).getInterfaces();
                    for (i = 0; i < interfaces.length; ++i) {
                        TypeInterface itf = (TypeInterface)interfaces[i];
                        if (!"server".equals(itf.getRole()) || !this.isMandatoryInterface(itf) || itf.getName().endsWith("controller") || this.isBoundInterface(bindingClientsSet, "this", itf)) continue;
                        String name = null;
                        if (node instanceof Definition) {
                            name = ((Definition)node).getName();
                        } else if (node instanceof Component) {
                            name = ((Component)node).getName();
                        }
                        throw new ADLException("Internal client interface of the server interface of composite \"" + name + "." + itf.getName() + "\" is not bound", (Node)node);
                    }
                }
            }
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], unboundMandatoryClientInterfacesMap);
            }
        }
    }

    private boolean isBoundInterface(HashSet presentBindings, String prefix, TypeInterface itf) {
        String itfName = prefix + "." + itf.getName();
        if (this.isSingletonInterface(itf)) {
            return presentBindings.contains(itfName);
        }
        Iterator iter = presentBindings.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).startsWith(itfName)) continue;
            return true;
        }
        return false;
    }

    private boolean isMandatoryInterface(TypeInterface itf) {
        String contingency = itf.getContingency();
        return contingency == null || "mandatory".equals(contingency);
    }

    private boolean isSingletonInterface(TypeInterface itf) {
        String cardinality = itf.getCardinality();
        return cardinality == null || "singleton".equals(cardinality);
    }
}

