/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.control.content.Util;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;

public abstract class BasicLifeCycleCoordinatorMixin
implements LifeCycleCoordinator {
    public List fcActive;
    public Component _this_weaveableC;

    private BasicLifeCycleCoordinatorMixin() {
    }

    public void setFcState(boolean started) throws IllegalLifeCycleException {
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot set the lifecycle state");
        }
        List allSubComponents = Util.getAllSubComponents(thisComponent);
        for (int i = 0; i < allSubComponents.size(); ++i) {
            LifeCycleCoordinator lc;
            Component c = (Component)allSubComponents.get(i);
            try {
                lc = (LifeCycleCoordinator)c.getFcInterface("lifecycle-controller");
            }
            catch (Exception e) {
                try {
                    lc = (LifeCycleCoordinator)c.getFcInterface("/lifecycle-coordinator");
                }
                catch (NoSuchInterfaceException f) {
                    continue;
                }
            }
            if (started) {
                lc.setFcStarted();
                continue;
            }
            lc.setFcStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fcActivated(LifeCycleCoordinator component) {
        List list = this.fcActive;
        synchronized (list) {
            if (this.fcActive.size() > 0) {
                if (!this.fcActive.contains(component)) {
                    this.fcActive.add(component);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fcInactivated(LifeCycleCoordinator component) {
        List list = this.fcActive;
        synchronized (list) {
            this.fcActive.remove(component);
            this.fcActive.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFc(LifeCycleCoordinator[] components) throws IllegalLifeCycleException {
        LifeCycleCoordinator c;
        this.fcActive = new ArrayList();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].getFcState().equals("STARTED")) continue;
            this.fcActive.add(components[i]);
        }
        try {
            c = (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("lifecycle-controller");
        }
        catch (Exception e) {
            try {
                c = (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("/lifecycle-coordinator");
            }
            catch (NoSuchInterfaceException f) {
                throw new ChainedIllegalLifeCycleException(f, this._this_weaveableC, "Cannot stop components");
            }
        }
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].getFcState().equals("STARTED")) continue;
            components[i].setFcStopping(c);
        }
        List i = this.fcActive;
        synchronized (i) {
            while (this.fcActive.size() > 0) {
                try {
                    this.fcActive.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        for (int i2 = 0; i2 < components.length; ++i2) {
            if (!components[i2].getFcState().equals("STARTED")) continue;
            components[i2].setFcStopped();
        }
        this.fcActive = null;
    }
}

