/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.loader;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.ClassGenerator;
import org.objectweb.fractal.julia.loader.BasicLoader;
import org.objectweb.fractal.julia.loader.Tree;

public class DynamicLoader
extends BasicLoader {
    private String genLog;
    private String genDir;

    public void init(Map context) throws Exception {
        super.init(context);
        if (context.get("julia.loader.gen.dir") != null) {
            this.genDir = (String)context.get("julia.loader.gen.dir");
        } else if (System.getProperty("julia.loader.gen.dir") != null) {
            this.genDir = System.getProperty("julia.loader.gen.dir");
        }
        if (context.get("julia.loader.gen.log") != null) {
            this.genLog = (String)context.get("julia.loader.gen.log");
        } else if (System.getProperty("julia.loader.gen.log") != null) {
            this.genLog = System.getProperty("julia.loader.gen.log");
        }
    }

    public Class loadClass(String name, Object loader) throws ClassNotFoundException {
        return PublicClassLoader.getInstance(this.getClassLoader(loader)).loadClass(name);
    }

    protected Class generateClass(String name, Tree classDescriptor, Object loader) throws ClassNotFoundException {
        ClassLoader cl = this.getClassLoader(loader);
        ClassGenerator classGen = null;
        try {
            classGen = (ClassGenerator)this.newObject(classDescriptor.getSubTree(0), loader);
        }
        catch (ClassCastException e) {
            throw new ClassGenerationException(null, classDescriptor.toString(), "The class generator is not an instance of ClassGenerator");
        }
        catch (Exception e) {
            throw new ClassGenerationException(e, classDescriptor.toString(), "Cannot create the class generator");
        }
        byte[] b = classGen.generateClass(name, classDescriptor, this, cl);
        if (this.genLog != null) {
            String line = classDescriptor.toString();
            if (this.genLog.equals("out")) {
                System.out.println(line);
            } else if (this.genLog.equals("err")) {
                System.err.println(line);
            } else {
                try {
                    FileWriter fw = new FileWriter(this.genLog, true);
                    fw.write(line);
                    fw.write(10);
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.genDir != null) {
            try {
                String cls;
                String pkg;
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    pkg = name.substring(0, dot).replace('.', File.separatorChar);
                    cls = name.substring(dot + 1);
                } else {
                    pkg = "";
                    cls = name;
                }
                File dirFile = new File(new File(this.genDir), pkg);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                File classFile = new File(dirFile, cls + ".class");
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(classFile));
                bos.write(b);
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return PublicClassLoader.getInstance(cl).defineClass(name, b);
    }

    private ClassLoader getClassLoader(Object loader) {
        if (loader instanceof ClassLoader) {
            return (ClassLoader)loader;
        }
        if (loader != null) {
            return loader.getClass().getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    static class PublicClassLoader
    extends ClassLoader {
        private static final Map INSTANCES = new HashMap();
        private Map bytecodes = new HashMap();

        private PublicClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PublicClassLoader getInstance(ClassLoader parent) {
            Map map = INSTANCES;
            synchronized (map) {
                PublicClassLoader instance = (PublicClassLoader)INSTANCES.get(parent);
                if (instance == null) {
                    instance = new PublicClassLoader(parent);
                    INSTANCES.put(parent, instance);
                }
                return instance;
            }
        }

        public Class defineClass(String name, byte[] b) {
            this.bytecodes.put(name.replace('.', '/') + ".class", b);
            return this.defineClass(name, b, 0, b.length);
        }

        public InputStream getResourceAsStream(String name) {
            byte[] b;
            InputStream is = super.getResourceAsStream(name);
            if (is == null && (b = (byte[])this.bytecodes.get(name)) != null) {
                is = new ByteArrayInputStream(b);
            }
            return is;
        }
    }
}

