/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.cartography.linux.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DatabaseConnection {
    private static Logger logger = Logger.getLogger(DatabaseConnection.class);

    public static void initDatabase(Connection connexion, String file, String databaseName) {
        String contenuFichier = null;
        String request = null;
        try {
            File f = new File(file);
            FileInputStream fluxFichier = new FileInputStream(file);
            byte[] contenu = new byte[(int)f.length()];
            ((InputStream)fluxFichier).read(contenu);
            contenuFichier = new String(contenu);
            ((InputStream)fluxFichier).close();
        }
        catch (IOException e) {
            logger.fatal((Object)("Some problems to read the following file : " + file));
            System.exit(1);
        }
        try {
            request = "DROP database " + databaseName;
            Statement stmt = connexion.createStatement();
            stmt.executeUpdate(request);
            request = "CREATE database " + databaseName;
            stmt.executeUpdate(request);
            request = "USE " + databaseName;
            stmt.executeUpdate(request);
        }
        catch (SQLException e) {
            logger.info((Object)("Problems with the following request:\n" + request + "\nError:\n" + e));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            StringTokenizer temp = new StringTokenizer(contenuFichier, ";");
            while (temp.hasMoreTokens()) {
                request = temp.nextToken();
                try {
                    Statement stmt = connexion.createStatement();
                    stmt.executeUpdate(request);
                }
                catch (SQLException e) {
                    logger.info((Object)("Problems with the following request:\n" + request + "\nError:\n" + e));
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static Connection connectToDatabase(String classeDriver, String url, String user, String psswd) {
        Connection connexion = null;
        Object contenuFichier = null;
        Object request = null;
        try {
            logger.info((Object)("loading JDBC driver " + classeDriver + " ..."));
            Class.forName(classeDriver).newInstance();
            logger.info((Object)"Driver loaded.");
            try {
                logger.info((Object)("Connection to database " + url + " ..."));
                connexion = DriverManager.getConnection(url, user, psswd);
                logger.info((Object)"Connection established.");
            }
            catch (SQLException ex) {
                logger.error((Object)("SQLException: " + ex.getMessage()));
                logger.error((Object)("SQLState: " + ex.getSQLState()));
                logger.error((Object)("VendorError: " + ex.getErrorCode()));
                System.exit(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Echec to load driver.");
            logger.error((Object)("Error:" + e));
            System.exit(1);
        }
        return connexion;
    }

    public static void request(Connection connexion, String req) {
        try {
            logger.debug((Object)req);
            PreparedStatement stmt = connexion.prepareStatement(req);
            stmt.executeUpdate(req);
        }
        catch (SQLException e) {
            logger.warn((Object)e);
        }
    }

    public static ResultSet requestResultSet(Connection connexion, String req) {
        ResultSet res = null;
        try {
            logger.debug((Object)req);
            PreparedStatement stmt = connexion.prepareStatement(req);
            res = stmt.executeQuery(req);
        }
        catch (SQLException e) {
            logger.warn((Object)e);
        }
        return res;
    }
}

