/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.objectweb.cjdbc.controller.authentication.PasswordAuthenticator;

public class JmxClient {
    protected JMXConnector connector;
    protected Object credentials;
    protected String remoteHostAddress;
    protected String remoteHostPort;

    public Object getCredentials() {
        return this.credentials;
    }

    public JmxClient(String port, String host, String jmxUser, String jmxPassword) throws IOException {
        this(port, host, PasswordAuthenticator.createCredentials((String)jmxUser, (String)jmxPassword));
    }

    public JmxClient(String port, String host, Object credentials) throws IOException {
        this.connect(port, host, credentials);
    }

    public void connect(String port, String host, Object credentials) throws IOException {
        JMXServiceURL address = new JMXServiceURL("rmi", host, 0, "/jndi/jrmp");
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        environment.put("java.naming.provider.url", "rmi://" + host + ":" + port);
        if (credentials != null) {
            environment.put("jmx.remote.credentials", credentials);
        }
        this.credentials = credentials;
        this.connector = JMXConnectorFactory.connect(address, environment);
        this.remoteHostAddress = host;
        this.remoteHostPort = port;
    }

    public ArrayList getAttribNames(String type) throws IOException, IntrospectionException, ReflectionException, InstanceNotFoundException {
        ArrayList<String> attribNames = new ArrayList<String>();
        MBeanServerConnection delegateConnection = this.connector.getMBeanServerConnection();
        Set mbeans = delegateConnection.queryNames(null, null);
        for (ObjectName mbeanName : mbeans) {
            MBeanInfo mbeanInfo = delegateConnection.getMBeanInfo(mbeanName);
            MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getType().equalsIgnoreCase(type)) continue;
                attribNames.add(mbeanName + " " + attributes[i].getName());
            }
        }
        return attribNames;
    }

    public Object getAttribValue(String name) throws IOException, MBeanException, MalformedObjectNameException, AttributeNotFoundException, ReflectionException, InstanceNotFoundException {
        Object obj = null;
        StringTokenizer tokenizer = new StringTokenizer(name, " ");
        ObjectName mbean = new ObjectName(tokenizer.nextToken().trim());
        String attrib = tokenizer.nextToken().trim();
        MBeanServerConnection delegateConnection = this.connector.getMBeanServerConnection();
        obj = delegateConnection.getAttribute(mbean, attrib);
        return obj;
    }
}

