/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx.cjdbc;

import java.io.IOException;
import java.util.HashSet;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.objectweb.cjdbc.common.jmx.JmxConstants;
import org.objectweb.cjdbc.common.jmx.mbeans.ControllerMBean;
import org.objectweb.cjdbc.common.jmx.mbeans.DataCollectorMBean;
import org.objectweb.cjdbc.common.jmx.mbeans.DatabaseBackendMBean;
import org.objectweb.cjdbc.common.jmx.mbeans.VirtualDatabaseMBean;
import org.objectweb.cjdbc.common.users.AdminUser;
import org.objectweb.lewys.probe.jmx.JmxClient;

public class CjdbcJmxClient
extends JmxClient {
    private ControllerMBean controllerMBean;
    private VirtualDatabaseMBean virtualDbMBean;
    private DatabaseBackendMBean backendMBean;
    public DataCollectorMBean dataMBean;

    public CjdbcJmxClient(String port, String host, String jmxUser, String jmxPassword) throws IOException {
        super(port, host, jmxUser, jmxPassword);
    }

    public CjdbcJmxClient(String port, String host, Object credentials) throws IOException {
        super(port, host, credentials);
    }

    public VirtualDatabaseMBean getVirtualDatabaseProxy(String database, String user, String password) throws IOException {
        if (this.virtualDbMBean != null && this.isValidConnection() && this.virtualDbMBean.getVirtualDatabaseName().equals(database)) {
            return this.virtualDbMBean;
        }
        ObjectName db = JmxConstants.getVirtualDbObjectName((String)database);
        AdminUser dbUser = new AdminUser(user, password);
        HashSet<AdminUser> principals = new HashSet<AdminUser>();
        principals.add(dbUser);
        Subject subj = new Subject(true, principals, new HashSet(), new HashSet());
        MBeanServerConnection delegateConnection = this.connector.getMBeanServerConnection(subj);
        this.virtualDbMBean = (VirtualDatabaseMBean)MBeanServerInvocationHandler.newProxyInstance(delegateConnection, db, VirtualDatabaseMBean.class, false);
        return this.virtualDbMBean;
    }

    public ControllerMBean getControllerProxy() throws IOException {
        if (this.controllerMBean != null && this.isValidConnection()) {
            return this.controllerMBean;
        }
        ObjectName db = JmxConstants.getControllerObjectName();
        this.controllerMBean = (ControllerMBean)MBeanServerInvocationHandler.newProxyInstance(this.connector.getMBeanServerConnection(), db, ControllerMBean.class, false);
        return this.controllerMBean;
    }

    public DataCollectorMBean getDataCollectorProxy() throws IOException {
        if (this.dataMBean != null && this.isValidConnection()) {
            return this.dataMBean;
        }
        ObjectName db = JmxConstants.getDataCollectorObjectName();
        this.dataMBean = (DataCollectorMBean)MBeanServerInvocationHandler.newProxyInstance(this.connector.getMBeanServerConnection(), db, DataCollectorMBean.class, false);
        return this.dataMBean;
    }

    public DatabaseBackendMBean getDatabaseBackendProxy(String vdbname, String backendname) throws IOException {
        if (this.backendMBean != null && this.isValidConnection()) {
            return this.backendMBean;
        }
        ObjectName db = JmxConstants.getDatabaseBackendObjectName((String)vdbname, (String)backendname);
        MBeanServerConnection delegateConnection = this.connector.getMBeanServerConnection();
        this.backendMBean = (DatabaseBackendMBean)MBeanServerInvocationHandler.newProxyInstance(delegateConnection, db, DatabaseBackendMBean.class, false);
        return this.backendMBean;
    }

    public String getRemoteName() {
        return this.remoteHostAddress + ":" + this.remoteHostPort;
    }

    public void reconnect() throws Exception {
        this.connect(this.remoteHostPort, this.remoteHostAddress, this.credentials);
    }

    public boolean isValidConnection() {
        try {
            this.connector.getMBeanServerConnection().getMBeanCount();
            return true;
        }
        catch (Exception e) {
            this.controllerMBean = null;
            this.backendMBean = null;
            this.virtualDbMBean = null;
            this.dataMBean = null;
            return false;
        }
    }
}

