/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class NetworkProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 16;
    private long[] bytesReceived;
    private long[] packetsReceived;
    private long[] errorsReceived;
    private long[] dropReceived;
    private long[] fifoReceived;
    private long[] frameReceived;
    private long[] compressedReceived;
    private long[] multicastReceived;
    private long[] bytesTransmit;
    private long[] packetsTransmit;
    private long[] errorsTransmit;
    private long[] dropTransmit;
    private long[] fifoTransmit;
    private long[] collisionsTransmit;
    private long[] carrierTransmit;
    private long[] compressedTransmit;
    private int nbOfDevices = 0;
    private RandomAccessFile procFile;
    private byte[] buffer;
    private static NoResourceToProbeException invalidFileFormat = new NoResourceToProbeException("Invalid /proc/net/dev file format for this probe.");
    private static final int BUFFER_SIZE = 1024;
    private int index;

    public NetworkProbe() throws NoResourceToProbeException {
        super("network probe");
        int i;
        try {
            this.procFile = new RandomAccessFile("/proc/net/dev", "r");
            this.buffer = new byte[1024];
            this.procFile.read(this.buffer);
            i = 0;
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            while (true) {
                if (this.buffer[i] == 32) {
                    ++i;
                    continue;
                }
                while (this.buffer[i] != 58) {
                    ++i;
                }
                ++i;
                for (int netStat = 0; netStat < 16; ++netStat) {
                    while (this.buffer[i] == 32) {
                        ++i;
                    }
                    while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                        ++i;
                    }
                    if (this.buffer[i] == 32 || this.buffer[i] == 10 || this.buffer[i] == 13) continue;
                    throw invalidFileFormat;
                }
                while (this.buffer[i] != 10 && i < 1024) {
                    ++i;
                }
                ++this.nbOfDevices;
                if (++i >= 1024 || this.buffer[i] == 0) break;
            }
        }
        catch (Exception e) {
            try {
                this.procFile.close();
            }
            catch (Exception ignore1) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        if (this.nbOfDevices == 0) {
            throw new NoResourceToProbeException();
        }
        this.bytesReceived = new long[this.nbOfDevices];
        this.packetsReceived = new long[this.nbOfDevices];
        this.errorsReceived = new long[this.nbOfDevices];
        this.dropReceived = new long[this.nbOfDevices];
        this.fifoReceived = new long[this.nbOfDevices];
        this.frameReceived = new long[this.nbOfDevices];
        this.compressedReceived = new long[this.nbOfDevices];
        this.multicastReceived = new long[this.nbOfDevices];
        this.bytesTransmit = new long[this.nbOfDevices];
        this.packetsTransmit = new long[this.nbOfDevices];
        this.errorsTransmit = new long[this.nbOfDevices];
        this.dropTransmit = new long[this.nbOfDevices];
        this.fifoTransmit = new long[this.nbOfDevices];
        this.collisionsTransmit = new long[this.nbOfDevices];
        this.carrierTransmit = new long[this.nbOfDevices];
        this.compressedTransmit = new long[this.nbOfDevices];
        this.resourceNames = new String[this.nbOfDevices * 16];
        this.resourceIds = new int[this.resourceNames.length];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        i = 0;
        while (this.buffer[i] != 10) {
            ++i;
        }
        ++i;
        while (this.buffer[i] != 10) {
            ++i;
        }
        this.index = ++i;
        for (int j = 0; j < this.nbOfDevices; ++j) {
            while (this.buffer[i] == 32) {
                ++i;
            }
            StringBuffer name = new StringBuffer();
            while (this.buffer[i] != 58) {
                name.append((char)this.buffer[i]);
                ++i;
            }
            this.resourceNames[j * 16] = name + " bytes received";
            this.resourceNames[j * 16 + 1] = name + " packets received";
            this.resourceNames[j * 16 + 2] = name + " errors received";
            this.resourceNames[j * 16 + 3] = name + " drop received";
            this.resourceNames[j * 16 + 4] = name + " fifo received";
            this.resourceNames[j * 16 + 5] = name + " frame received";
            this.resourceNames[j * 16 + 6] = name + " compressed received";
            this.resourceNames[j * 16 + 7] = name + " multicast";
            this.resourceNames[j * 16 + 8] = name + " bytes transmit";
            this.resourceNames[j * 16 + 9] = name + " packets transmit";
            this.resourceNames[j * 16 + 10] = name + " errors transmit";
            this.resourceNames[j * 16 + 11] = name + " drop transmit";
            this.resourceNames[j * 16 + 12] = name + " fifo transmit";
            this.resourceNames[j * 16 + 13] = name + " collisions";
            this.resourceNames[j * 16 + 14] = name + " carrier";
            this.resourceNames[j * 16 + 15] = name + " compressed transmit";
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.procFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getNetworkUsage();
        long[] result = new long[resourceIds.length];
        block18: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 16 * this.nbOfDevices) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int net = resourceIds[i] / 16;
            switch (resourceIds[i] % 16) {
                case 0: {
                    result[i] = this.bytesReceived[net];
                    continue block18;
                }
                case 1: {
                    result[i] = this.packetsReceived[net];
                    continue block18;
                }
                case 2: {
                    result[i] = this.errorsReceived[net];
                    continue block18;
                }
                case 3: {
                    result[i] = this.dropReceived[net];
                    continue block18;
                }
                case 4: {
                    result[i] = this.fifoReceived[net];
                    continue block18;
                }
                case 5: {
                    result[i] = this.frameReceived[net];
                    continue block18;
                }
                case 6: {
                    result[i] = this.compressedReceived[net];
                    continue block18;
                }
                case 7: {
                    result[i] = this.multicastReceived[net];
                    continue block18;
                }
                case 8: {
                    result[i] = this.bytesTransmit[net];
                    continue block18;
                }
                case 9: {
                    result[i] = this.packetsTransmit[net];
                    continue block18;
                }
                case 10: {
                    result[i] = this.errorsTransmit[net];
                    continue block18;
                }
                case 11: {
                    result[i] = this.dropTransmit[net];
                    continue block18;
                }
                case 12: {
                    result[i] = this.fifoTransmit[net];
                    continue block18;
                }
                case 13: {
                    result[i] = this.collisionsTransmit[net];
                    continue block18;
                }
                case 14: {
                    result[i] = this.carrierTransmit[net];
                    continue block18;
                }
                case 15: {
                    result[i] = this.compressedTransmit[net];
                    continue block18;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getNetworkUsage() throws ProbeException {
        try {
            this.procFile.seek(0L);
            this.procFile.read(this.buffer);
            int i = this.index;
            int currentDevice = 0;
            while (true) {
                if (this.buffer[i] == 32) {
                    ++i;
                    continue;
                }
                while (this.buffer[i] != 58) {
                    ++i;
                }
                ++i;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                long foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.bytesReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.packetsReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.errorsReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.dropReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.fifoReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.frameReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.compressedReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.multicastReceived[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.bytesTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.packetsTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.errorsTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.dropTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.fifoTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.collisionsTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.carrierTransmit[currentDevice] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.compressedTransmit[currentDevice] = foo;
                while (this.buffer[i] != 10 && i < 1024) {
                    ++i;
                }
                ++i;
                if (++currentDevice >= this.nbOfDevices) break;
            }
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

