/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class DiskProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 14;
    private long[] readsIssued;
    private long[] readsMerged;
    private long[] readSectors;
    private long[] readTimeInMs;
    private long[] writesIssued;
    private long[] writesMerged;
    private long[] writeSectors;
    private long[] writeTimeInMs;
    private long[] ioInProgress;
    private long[] ioInMs;
    private long[] averageIoMs;
    private long[] bytesRead;
    private long[] bytesWritten;
    private long[] ioSplitted;
    private int nbOfDisks = 0;
    private String[] DisksNames = this.getDiskNames();

    public DiskProbe() throws NoResourceToProbeException {
        super("disk probe");
        this.nbOfDisks = this.DisksNames.length;
        this.readsIssued = new long[this.nbOfDisks];
        this.readsMerged = new long[this.nbOfDisks];
        this.readSectors = new long[this.nbOfDisks];
        this.readTimeInMs = new long[this.nbOfDisks];
        this.writesIssued = new long[this.nbOfDisks];
        this.writesMerged = new long[this.nbOfDisks];
        this.writeSectors = new long[this.nbOfDisks];
        this.writeTimeInMs = new long[this.nbOfDisks];
        this.ioInProgress = new long[this.nbOfDisks];
        this.ioInMs = new long[this.nbOfDisks];
        this.averageIoMs = new long[this.nbOfDisks];
        this.bytesRead = new long[this.nbOfDisks];
        this.bytesWritten = new long[this.nbOfDisks];
        this.ioSplitted = new long[this.nbOfDisks];
        this.resourceNames = new String[this.nbOfDisks * 14];
        this.resourceIds = new int[this.resourceNames.length];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (int j = 0; j < this.nbOfDisks; ++j) {
            this.resourceNames[j * 14] = this.DisksNames[j] + " reads issued";
            this.resourceNames[j * 14 + 1] = this.DisksNames[j] + " reads merged";
            this.resourceNames[j * 14 + 2] = this.DisksNames[j] + " read sectors";
            this.resourceNames[j * 14 + 3] = this.DisksNames[j] + " read time in ms";
            this.resourceNames[j * 14 + 4] = this.DisksNames[j] + " writes issued";
            this.resourceNames[j * 14 + 5] = this.DisksNames[j] + " writes merged";
            this.resourceNames[j * 14 + 6] = this.DisksNames[j] + " write sectors";
            this.resourceNames[j * 14 + 7] = this.DisksNames[j] + " write time in ms";
            this.resourceNames[j * 14 + 8] = this.DisksNames[j] + " io in progress";
            this.resourceNames[j * 14 + 9] = this.DisksNames[j] + " io in ms";
            this.resourceNames[j * 14 + 10] = this.DisksNames[j] + " average io in ms";
            this.resourceNames[j * 14 + 11] = this.DisksNames[j] + " bytes read";
            this.resourceNames[j * 14 + 12] = this.DisksNames[j] + " bytes written";
            this.resourceNames[j * 14 + 13] = this.DisksNames[j] + " I/O splitted";
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getDiskUsage();
        long[] result = new long[resourceIds.length];
        block16: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 14 * this.nbOfDisks) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int disk = resourceIds[i] / 14;
            switch (resourceIds[i] % 14) {
                case 0: {
                    result[i] = this.readsIssued[disk];
                    continue block16;
                }
                case 1: {
                    result[i] = this.readsMerged[disk];
                    continue block16;
                }
                case 2: {
                    result[i] = this.readSectors[disk];
                    continue block16;
                }
                case 3: {
                    result[i] = this.readTimeInMs[disk];
                    continue block16;
                }
                case 4: {
                    result[i] = this.writesIssued[disk];
                    continue block16;
                }
                case 5: {
                    result[i] = this.writesMerged[disk];
                    continue block16;
                }
                case 6: {
                    result[i] = this.writeSectors[disk];
                    continue block16;
                }
                case 7: {
                    result[i] = this.writeTimeInMs[disk];
                    continue block16;
                }
                case 8: {
                    result[i] = this.ioInProgress[disk];
                    continue block16;
                }
                case 9: {
                    result[i] = this.ioInMs[disk];
                    continue block16;
                }
                case 10: {
                    result[i] = this.averageIoMs[disk];
                    continue block16;
                }
                case 11: {
                    result[i] = this.bytesRead[disk];
                    continue block16;
                }
                case 12: {
                    result[i] = this.bytesWritten[disk];
                    continue block16;
                }
                case 13: {
                    result[i] = this.ioSplitted[disk];
                    continue block16;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getDiskUsage() throws ProbeException {
        for (int disk = 0; disk < this.nbOfDisks; ++disk) {
            long[] results = this.getDiskState(this.DisksNames[disk]);
            if (results.length < 14) {
                throw new ProbeException("Bad result from native method: getDiskUsage");
            }
            this.readsIssued[disk] = results[0];
            this.readsMerged[disk] = results[1];
            this.readSectors[disk] = results[2];
            this.readTimeInMs[disk] = results[3];
            this.writesIssued[disk] = results[4];
            this.writesMerged[disk] = results[5];
            this.writeSectors[disk] = results[6];
            this.writeTimeInMs[disk] = results[7];
            this.ioInProgress[disk] = results[8];
            this.ioInMs[disk] = results[9];
            this.averageIoMs[disk] = results[10];
            this.bytesRead[disk] = results[11];
            this.bytesWritten[disk] = results[12];
            this.ioSplitted[disk] = results[13];
        }
    }

    public native String[] getDiskNames();

    public native long[] getDiskState(String var1);

    static {
        System.loadLibrary("LeWYS");
    }
}

