/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class MemoryProbe
extends AbstractProbe {
    private static final int NB_OF_RESSOURCES = 9;
    private long[] resourceValues;

    public MemoryProbe() throws NoResourceToProbeException {
        super("memory probe");
        this.resourceIds = new int[9];
        this.resourceValues = new long[9];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        this.resourceNames = new String[]{"Total memory", "Used memory", "Free memory", "Shared", "Buffers", "Cached", "Total swap", "Used swap", "Free swap"};
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getMemoryUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 9) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    private void getMemoryUsage() throws ProbeException {
        this.resourceValues = this.getMemoryState();
    }

    public native long[] getMemoryState();

    static {
        System.loadLibrary("LeWYS");
    }
}

