/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.systat;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.filtering.SlideFilter;
import org.objectweb.lewys.filtering.SwingFilter;

public class FilterSystatOutput {
    private int matched = 0;
    private int totalDataPoints = 0;

    public FilterSystatOutput(BufferedReader input, Filter filter, int resourceId, int nbOfResources) {
        try {
            for (int i = 0; i < nbOfResources; ++i) {
                if (i == resourceId) {
                    System.out.println(input.readLine());
                    continue;
                }
                input.readLine();
            }
            long start = System.currentTimeMillis();
            String s = null;
            while ((s = input.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s);
                StringTokenizer timeStr = new StringTokenizer(st.nextToken(), ":,");
                double time = 0.0;
                time += (double)(Integer.parseInt(timeStr.nextToken()) * 3600000);
                time += (double)(Integer.parseInt(timeStr.nextToken()) * 600000);
                time += (double)(Integer.parseInt(timeStr.nextToken()) * 1000);
                time += (double)Integer.parseInt(timeStr.nextToken());
                for (int i = 0; i < resourceId; ++i) {
                    st.nextToken();
                }
                long value = Long.parseLong(st.nextToken());
                SignalPoint point = new SignalPoint(time, value);
                if (filter != null && filter.getKeyPoint(point) == null) {
                    ++this.matched;
                }
                ++this.totalDataPoints;
            }
            long end = System.currentTimeMillis();
            System.out.println("Total time: " + (end - start) + " ms");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to read from file, exiting...");
            System.exit(1);
        }
    }

    public int getMatched() {
        return this.matched;
    }

    public int getTotalDataPoints() {
        return this.totalDataPoints;
    }

    public static void main(String[] args) {
        try {
            Filter filter;
            BufferedReader input = new BufferedReader(new FileReader(args[0]));
            if ("null".equals(args[1])) {
                filter = null;
            } else {
                Filter optimized;
                filter = (Filter)Class.forName(args[1]).newInstance();
                filter.setPrecisionWidth(Double.parseDouble(args[2]));
                if (filter instanceof SlideFilter) {
                    optimized = (SlideFilter)filter;
                    ((SlideFilter)optimized).setOptimizerOn(false);
                }
                if (filter instanceof SwingFilter) {
                    optimized = (SwingFilter)filter;
                    ((SwingFilter)optimized).setOptimizerOn(false);
                }
            }
            int resourceId = Integer.parseInt(args[3]);
            int nbOfResources = Integer.parseInt(args[4]);
            if (resourceId >= nbOfResources) {
                System.exit(0);
            }
            FilterSystatOutput process = new FilterSystatOutput(input, filter, resourceId, nbOfResources);
            System.out.println("Total points: " + process.getTotalDataPoints());
            System.out.println("Cached points: " + process.getMatched());
            System.out.println("Efficiency: " + (100.0 - (double)(process.getTotalDataPoints() - process.getMatched()) / (double)process.getTotalDataPoints() * 100.0) + "%");
        }
        catch (Exception e) {
            e.printStackTrace();
            FilterSystatOutput.displayUsageAndQuit();
        }
    }

    private static void displayUsageAndQuit() {
        System.out.println("java org.objectweb.lewys.systat.FilterSystatOutput filename filterclass precisionWidth resourceid nbOfResources");
        System.out.println("Example:");
        System.out.println("java org.objectweb.lewys.systat.FilterSystatOutput /tmp/cpu.log org.objectweb.lewys.filtering.CacheFilter 1000 0 5");
        System.exit(1);
    }
}

