/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.systat;

import org.objectweb.lewys.probe.Probe;
import org.objectweb.lewys.systat.ProbingThread;

public class Systat {
    public static void main(String[] args) {
        try {
            int sampling = Integer.parseInt(args[0]);
            int samples = Integer.parseInt(args[1]);
            Probe[] probes = new Probe[args.length - 2];
            for (int i = 2; i < args.length; ++i) {
                String className = args[i];
                probes[i - 2] = (Probe)Class.forName(className).newInstance();
            }
            ProbingThread thread = new ProbingThread(probes, sampling, samples);
            thread.start();
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            Systat.displayUsageAndQuit();
        }
    }

    private static void displayUsageAndQuit() {
        System.out.println("java org.objectweb.lewys.systat.Systat sampling_interval_in_ms number_of_samples probe1 probe2 ... proben");
        System.out.println("If number_of_samples is set to 0, then an infinite number of samples are generated (kill the process to stop).");
        System.out.println("probex: name of the Java class implementing the org.objectweb.lewys.probe.Probe interface.");
        System.out.println("Example to probe cpu, disk, memory, network and kernel under linux every second for one minute:");
        System.out.println("java org.objectweb.lewys.systat.Systat 1000 60 org.objectweb.lewys.probe.linux.CpuProbe org.objectweb.lewys.probe.linux.DiskProbe org.objectweb.lewys.probe.linux.NetworkProbe org.objectweb.lewys.probe.linux.MemoryProbe org.objectweb.lewys.probe.linux.KernelProbe");
        System.exit(1);
    }
}

