/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import junit.framework.Assert;
import org.objectweb.util.monolog.TestHelper;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.TopicalLogger;

public class TestLogger
extends TestHelper {
    public static final String LOG_FILE_NAME = "test.log";
    public static final String LOG_PATTERN = "%m%n";
    TopicalLogger l = null;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestLogger;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Syntax error !");
            System.out.println("java TestLogger <logger factory class name>");
            System.exit(1);
        }
        TestHelper.run(class$org$objectweb$util$monolog$TestLogger == null ? (class$org$objectweb$util$monolog$TestLogger = TestLogger.class$("org.objectweb.util.monolog.TestLogger")) : class$org$objectweb$util$monolog$TestLogger, new String[0], new String[0], args[0]);
    }

    public static TestSuite getTestSuite(String lfcn) {
        return TestHelper.getTestSuite(class$org$objectweb$util$monolog$TestLogger == null ? (class$org$objectweb$util$monolog$TestLogger = TestLogger.class$("org.objectweb.util.monolog.TestLogger")) : class$org$objectweb$util$monolog$TestLogger, new String[0], new String[0], lfcn);
    }

    public void testNbLogger() {
        TestLogger.assertEquals((String)"nb initial loggers", (int)1, (int)this.lf.getLoggers().length);
    }

    public void testRootLoggerConf() {
        this.l = (TopicalLogger)this.lf.getLogger("");
        TestLogger.assertNotNull((String)"Root logger undefined", (Object)this.l);
        String[] ts = this.l.getTopic();
        TestLogger.assertNotNull((String)"Topic list is null", (Object)ts);
        TestLogger.assertEquals((String)"several topic", (int)1, (int)ts.length);
        TestLogger.assertNotNull((String)"Topic list is null", (Object)ts[0]);
        TestLogger.assertEquals((String)"name 'root' not equals to ''", (Object)this.l, (Object)this.lf.getLogger("root"));
        TestLogger.assertTrue((String)"several topic", (ts[0].length() == 0 || "root".equals(ts[0]) ? 1 : 0) != 0);
    }

    public void testGetOneLoggerByName() {
        this.l = (TopicalLogger)this.lf.getLogger("foo");
        TestLogger.assertEquals((String)"same name but 2 instances", (Object)this.l, (Object)this.lf.getLogger("foo"));
        String[] topics = ((TopicalLogger)this.lf.getLogger("foo")).getTopic();
        TestLogger.assertNotNull((String)"Topic list is null", (Object)topics);
        TestLogger.assertEquals((String)"several topic", (int)1, (int)topics.length);
        TestLogger.assertNotNull((String)"Topic elem is null", (Object)topics[0]);
        TestLogger.assertTrue((String)"bad name", (boolean)topics[0].equals("foo"));
    }

    public void testGetAllLoggerConf() {
        int i;
        int iternumber = 20;
        for (int i2 = 0; i2 < iternumber; ++i2) {
            this.l = (TopicalLogger)this.lf.getLogger("foo" + i2);
        }
        TopicalLogger[] locs = (TopicalLogger[])this.lf.getLoggers();
        TestLogger.assertNotNull((String)"LoggerConf list is null", (Object)locs);
        TopicalLogger[] locs2 = new TopicalLogger[iternumber];
        for (int i3 = 0; i3 < locs.length; ++i3) {
            TestLogger.assertNotNull((String)"LoggerConf list element is null", (Object)locs[i3]);
            String[] ts = locs[i3].getTopic();
            TestLogger.assertNotNull((String)"topic list is null", (Object)ts);
            TestLogger.assertEquals((String)"bad Topic list size", (int)1, (int)ts.length);
            TestLogger.assertNotNull((String)"Null topic", (Object)ts[0]);
            int j = 0;
            if (ts[0].length() <= 3 || !ts[0].startsWith("foo", 0)) continue;
            try {
                j = Integer.parseInt(ts[0].substring(3, ts[0].length()));
            }
            catch (NumberFormatException e) {
                TestLogger.fail((String)("Bad topic name: " + ts[0]));
            }
            TestLogger.assertNull((String)"duplicate LoggerConf", (Object)locs2[j]);
            locs2[j] = locs[i3];
            TestLogger.assertEquals((String)"bad topic", (Object)("foo" + j), (Object)ts[0]);
        }
        boolean allset = true;
        for (i = 0; i < iternumber && allset; ++i) {
            allset = locs2[i] != null;
        }
        if (!allset) {
            for (i = 0; i < iternumber; ++i) {
                if (locs2[i] == null) {
                    System.out.println("losc2[" + i + "]=null");
                    continue;
                }
                System.out.println("losc2[" + i + "]=" + locs2[i].getTopic()[0]);
            }
            TestLogger.assertTrue((String)"Some logger has not been found", (boolean)allset);
        }
    }

    public void testMultipleTopic() {
        this.l = (TopicalLogger)this.lf.getLogger("foo");
        TestLogger.assertEquals((String)"same name but 2 instances", (Object)this.l, (Object)this.lf.getLogger("foo"));
        try {
            this.l.addTopic("bar");
            this.l.addTopic("azerty");
            this.l.addTopic("querty");
        }
        catch (Exception e) {
            TestLogger.fail((String)"does not support multiple topic");
        }
        String[] tcs = this.l.getTopic();
        TestLogger.assertNotNull((String)"Topic list is null", (Object)tcs);
        TestLogger.assertEquals((String)"Wrong topic number", (int)4, (int)tcs.length);
        String[] tcs2 = new String[4];
        for (int i = 0; i < tcs.length; ++i) {
            TestLogger.assertNotNull((String)"Null topic", (Object)tcs[i]);
            if (tcs[i].equals("foo")) {
                TestLogger.assertNull((String)"duplicate first name", (Object)tcs2[0]);
                tcs2[0] = tcs[i];
                continue;
            }
            if (tcs[i].equals("bar")) {
                TestLogger.assertNull((String)"duplicate name", (Object)tcs2[1]);
                tcs2[1] = tcs[i];
                continue;
            }
            if (tcs[i].equals("azerty")) {
                TestLogger.assertNull((String)"duplicate name", (Object)tcs2[2]);
                tcs2[2] = tcs[i];
                continue;
            }
            if (!tcs[i].equals("querty")) continue;
            TestLogger.assertNull((String)"duplicate name", (Object)tcs2[3]);
            tcs2[3] = tcs[i];
        }
    }

    public void testSimpleInheritanceLevel() {
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.inheritance.level.toto");
        this.l.setIntLevel(BasicLevel.WARN);
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.inheritance.level.toto.titi");
        TestLogger.assertTrue((String)"wrong isLoggable return 1", (boolean)this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue((String)"wrong isLoggable return 2", (!this.l.isLoggable(BasicLevel.DEBUG) ? 1 : 0) != 0);
        this.l.setIntLevel(BasicLevel.DEBUG);
        TestLogger.assertTrue((String)"wrong isLoggable return 3", (boolean)this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue((String)"wrong isLoggable return 4", (boolean)this.l.isLoggable(BasicLevel.DEBUG));
    }

    public void testTopicsInheritanceLevel() {
        this.l = (TopicalLogger)this.lf.getLogger("test.topic.inheritance.level.toto");
        this.l.setIntLevel(BasicLevel.WARN);
        this.l = (TopicalLogger)this.lf.getLogger("test.topic.inheritance.level.toto.titi");
        TestLogger.assertTrue((String)"wrong isLoggable return 1", (boolean)this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue((String)"wrong isLoggable return 2", (!this.l.isLoggable(BasicLevel.DEBUG) ? 1 : 0) != 0);
        try {
            this.l.addTopic("test.topic.inheritance.level.tutu.titi");
        }
        catch (Exception e) {
            Assert.fail((String)("Multiple topic error: " + e.getMessage()));
        }
        this.l = (TopicalLogger)this.lf.getLogger("test.topic.inheritance.level.tutu");
        this.l.setIntLevel(BasicLevel.DEBUG);
        TestLogger.assertTrue((String)"wrong isLoggable return 3", (boolean)this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue((String)"wrong isLoggable return 4", (boolean)this.l.isLoggable(BasicLevel.DEBUG));
    }

    public void testLogInCollocatedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log");
        Handler hc = this.hf.createHandler("myhandler", (byte)1);
        hc.setAttribute("output", LOG_FILE_NAME);
        hc.setAttribute("pattern", LOG_PATTERN);
        try {
            this.l.addHandler(hc);
        }
        catch (Exception e) {
            TestLogger.fail((String)e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"collocated Handler bar");
        String[] found = this.getFirstLines(LOG_FILE_NAME, 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith("collocated Handler bar"));
    }

    public void testLogInSeveralCollocatedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log");
        Handler hc1 = this.hf.createHandler("myhandler", (byte)1);
        hc1.setAttribute("output", "test.log1");
        hc1.setAttribute("pattern", LOG_PATTERN);
        Handler hc2 = this.hf.createHandler("myhandler2", (byte)1);
        hc2.setAttribute("output", "test.log2");
        hc2.setAttribute("pattern", LOG_PATTERN);
        try {
            this.l.addHandler(hc1);
            this.l.addHandler(hc2);
        }
        catch (Exception e) {
            TestLogger.fail((String)e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"several collocated Handler bar");
        String[] found = this.getFirstLines("test.log1", 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith("several collocated Handler bar"));
        found = this.getFirstLines("test.log2", 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith("several collocated Handler bar"));
    }

    public void testLogInInheritedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log");
        Handler hc = this.hf.createHandler("myhandler", (byte)1);
        hc.setAttribute("output", LOG_FILE_NAME);
        hc.setAttribute("pattern", LOG_PATTERN);
        try {
            this.l.addHandler(hc);
        }
        catch (Exception e) {
            TestLogger.fail((String)e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log.foo");
        this.l.log(BasicLevel.DEBUG, (Object)"inherited Handler bar");
        String[] found = this.getLastLines(LOG_FILE_NAME, 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in inherited Handler", (boolean)found[0].endsWith("inherited Handler bar"));
    }

    public void testLogInSeveralInheritedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log");
        Handler hc1 = this.hf.createHandler("myhandler", (byte)1);
        hc1.setAttribute("output", "test.log1");
        hc1.setAttribute("pattern", LOG_PATTERN);
        Handler hc2 = this.hf.createHandler("myhandler2", (byte)1);
        hc2.setAttribute("output", "test.log2");
        hc2.setAttribute("pattern", LOG_PATTERN);
        try {
            this.l.addHandler(hc1);
            this.l = (TopicalLogger)this.lf.getLogger("test.simple.log.foo");
            this.l.addHandler(hc2);
        }
        catch (Exception e) {
            TestLogger.fail((String)e.getMessage());
        }
        this.l = (TopicalLogger)this.lf.getLogger("test.simple.log.foo.bar");
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"several collocated Handler bar");
        String[] found = this.getFirstLines("test.log1", 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith("several collocated Handler bar"));
        found = this.getFirstLines("test.log2", 1);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found);
        TestLogger.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestLogger.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith("several collocated Handler bar"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

