/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.file.monolog;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.objectweb.util.monolog.TestHelper;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public class TestPropertiesConfAccess
extends TestHelper {
    static /* synthetic */ Class class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Syntax error !");
            System.out.println("java TestPropertiesConfAccess <logger factory class name>");
            System.exit(1);
        }
        TestHelper.run(class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess == null ? (class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess = TestPropertiesConfAccess.class$("org.objectweb.util.monolog.file.monolog.TestPropertiesConfAccess")) : class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess, new String[0], new String[0], args[0]);
    }

    public static TestSuite getTestSuite(String lfcn) {
        return TestHelper.getTestSuite(class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess == null ? (class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess = TestPropertiesConfAccess.class$("org.objectweb.util.monolog.file.monolog.TestPropertiesConfAccess")) : class$org$objectweb$util$monolog$file$monolog$TestPropertiesConfAccess, new String[0], new String[0], lfcn);
    }

    public void testStoreConf() {
        try {
            TestPropertiesConfAccess.assertNotNull((String)"Bad definition", (Object)this.lef.defineLevel("DEBUG1", BasicLevel.DEBUG + 1));
            TestPropertiesConfAccess.assertNotNull((String)"Bad definition", (Object)this.lef.defineLevel("DEBUG2", "DEBUG + 2"));
            TestPropertiesConfAccess.assertNotNull((String)"Bad definition", (Object)this.lef.defineLevel("DEBUG2bis", BasicLevel.DEBUG + 2));
            TestPropertiesConfAccess.assertNotNull((String)"Bad definition", (Object)this.lef.defineLevel("INFObis", BasicLevel.INFO));
            TestPropertiesConfAccess.assertNotNull((String)"Bad definition", (Object)this.lef.defineLevel("WARNbis", "WARN"));
            this.lef.defineLevel("FATAL", "50000");
            Handler h = this.hf.createHandler("handler_sys_out", (byte)2);
            h.setAttribute("output", "System.out");
            h.setAttribute("pattern", "%m%n");
            h = this.hf.createHandler("Handler_file", (byte)1);
            h.setAttribute("output", "toto.txt");
            h.setAttribute("pattern", "%p %m%n");
            h = this.hf.createHandler("Handler.rolling.file", (byte)3);
            h.setAttribute("output", "toto");
            h.setAttribute("maxSize", "300");
            h.setAttribute("fileNumber", "2");
            h.setAttribute("pattern", "%p - %m%n");
            TopicalLogger l = null;
            l = (TopicalLogger)this.lf.getLogger("");
            l.setIntLevel(BasicLevel.WARN);
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar");
            l = (TopicalLogger)this.lf.getLogger("org");
            l.setIntLevel(BasicLevel.FATAL);
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar2");
            l.setIntLevel(BasicLevel.INFO);
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar3");
            l.addTopic("fr.inria.sardes3");
            l.addTopic("fr.inrialpes.sardes3");
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar4");
            l.setIntLevel(BasicLevel.ERROR);
            l.addTopic("fr.inria.sardes4");
            l.addTopic("fr.inrialpes.sardes4");
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar5");
            l.addHandler(this.hf.getHandler("Handler_file"));
            l = (TopicalLogger)this.lf.getLogger("org.foo.bar6");
            l.addHandler(this.hf.getHandler("Handler_file"));
            l.addHandler(this.hf.getHandler("Handler.rolling.file"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertiesConfAccess.fail((String)e.getMessage());
        }
        Properties p = new Properties();
        try {
            PropertiesConfAccess.store(p, this.lf, this.hf, this.lef);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertiesConfAccess.fail((String)e.getMessage());
        }
        Set<Object> s = p.keySet();
        this.checkExist(p, s, "level.DEBUG1", String.valueOf(BasicLevel.DEBUG + 1), "level: integer value");
        this.checkExist(p, s, "level.DEBUG2", "DEBUG + 2", "level: string expr");
        this.checkExist(p, s, "level.DEBUG2bis", String.valueOf(BasicLevel.DEBUG + 2), "level: integer value, duplicat");
        this.checkExist(p, s, "level.INFObis", "20000", "level: value");
        this.checkExist(p, s, "level.WARNbis", "WARN", "level: value");
        this.checkUnExist(s, "level.FATAL", "level: predefined level");
        this.checkExist(p, s, "handler.handler_sys_out.type", "Console", "handler: bad console type");
        this.checkExist(p, s, "handler.handler_sys_out.output", "System.out", "handler: bad console output");
        this.checkExist(p, s, "handler.handler_sys_out.pattern", "%m%n", "handler: bad console pattern");
        this.checkExist(p, s, "handler.Handler_file.type", "File", "handler: bad file type");
        this.checkExist(p, s, "handler.Handler_file.output", "toto.txt", "handler: bad file output");
        this.checkExist(p, s, "handler.Handler_file.pattern", "%p %m%n", "handler: bad file pattern");
        this.checkExist(p, s, "handler.Handler.rolling.file.type", "RollingFile", "handler: bad rolling file type");
        this.checkExist(p, s, "handler.Handler.rolling.file.output", "toto", "handler: bad rolling file output");
        this.checkExist(p, s, "handler.Handler.rolling.file.pattern", "%p - %m%n", "handler: bad rolling file pattern");
        this.checkExist(p, s, "handler.Handler.rolling.file.maxSize", "300", "handler: bad rolling file max size");
        this.checkExist(p, s, "handler.Handler.rolling.file.fileNumber", "2", "handler: bad rolling file number of file");
        this.checkUnExist(s, "logger.org.foo.bar.level", "just the name");
        this.checkExist(p, s, "logger.org.level", "FATAL", "logger: Simple name & Just level");
        this.checkExist(p, s, "logger.org.foo.bar2.level", "INFO", "logger: Dotted name & Just level");
        this.checkBeginExist(p, "logger.org.foo.bar5.handler.", "Handler_file", "logger: Dotted name & Just handler");
        this.checkBeginExist(p, "logger.org.foo.bar6.handler.", "Handler_file", "logger: Dotted name & Just handler");
        this.checkBeginExist(p, "logger.org.foo.bar6.handler.", "Handler.rolling.file", "logger: Dotted name & Just handler");
        this.checkBeginExist(p, "logger.org.foo.bar3.topic.", "fr.inria.sardes3", "logger: Dotted name, no level, 2 topic: topic1");
        this.checkBeginExist(p, "logger.org.foo.bar3.topic.", "fr.inrialpes.sardes3", "logger: Dotted name, no level, 2 topic: topic2");
        this.checkExist(p, s, "logger.org.foo.bar4.level", "ERROR", "logger: Dotted name, Just level, topic: level");
        this.checkBeginExist(p, "logger.org.foo.bar4.topic.", "fr.inria.sardes4", "logger: Dotted name, ERROR level, 2 topic: topic1");
        this.checkBeginExist(p, "logger.org.foo.bar4.topic.", "fr.inrialpes.sardes4", "logger: Dotted name, ERROR level, 2 topic: topic2");
    }

    public void testLoadConf() {
        Properties p = new Properties();
        p.setProperty("level.LOAD_DEBUG1", "DEBUG + 1");
        p.setProperty("level.LOAD_DEBUG2", String.valueOf(BasicLevel.DEBUG + 2));
        p.setProperty("handler.myhandler1.type", "Console");
        p.setProperty("handler.myhandler1.output", "System.out");
        p.setProperty("handler.myhandler1.pattern", "%m%n");
        p.setProperty("handler.test.load.myhandler2.type", "File");
        p.setProperty("handler.test.load.myhandler2.output", "myhandler2.log");
        p.setProperty("handler.test.load.myhandler2.pattern", "=> %m%n");
        p.setProperty("handler.test.load.myhandler3.type", "RollingFile");
        p.setProperty("handler.test.load.myhandler3.output", "myhandler3.log");
        p.setProperty("handler.test.load.myhandler3.pattern", "-> %m%n");
        p.setProperty("handler.test.load.myhandler3.fileNumber", "2");
        p.setProperty("handler.test.load.myhandler3.maxSize", "20");
        p.setProperty("logger.test.load.bar.level", "DEBUG");
        p.setProperty("logger.test.load.foo.level", "LOAD_DEBUG1");
        p.setProperty("logger.test.load.foo2.topic.0", "org.ow.foo");
        p.setProperty("logger.test.load.foo2.topic.1", "org.ow.foo2");
        p.setProperty("logger.test.load.foo3.handler.0", "myhandler1");
        p.setProperty("logger.test.load.foo4.handler.0", "test.load.myhandler2");
        p.setProperty("logger.test.load.foo4.handler.1", "test.load.myhandler3");
        try {
            PropertiesConfAccess.load(p, this.lf, this.hf, this.lef);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestPropertiesConfAccess.fail((String)e.getMessage());
        }
        Level le = null;
        le = this.lef.getLevel("LOAD_DEBUG1");
        TestPropertiesConfAccess.assertNotNull((String)"level: LOAD_DEBUG1: undefined", (Object)le);
        TestPropertiesConfAccess.assertEquals((String)"level: LOAD_DEBUG1: bad int value", (int)(BasicLevel.DEBUG + 1), (int)le.getIntValue());
        TestPropertiesConfAccess.assertEquals((String)"level: LOAD_DEBUG1: bad string expr", (Object)"DEBUG + 1", (Object)((LevelImpl)le).getStringValue());
        le = this.lef.getLevel("LOAD_DEBUG2");
        TestPropertiesConfAccess.assertNotNull((String)"level: LOAD_DEBUG2: undefined", (Object)le);
        TestPropertiesConfAccess.assertEquals((String)"level: LOAD_DEBUG2: bad int value", (int)(BasicLevel.DEBUG + 2), (int)le.getIntValue());
        TestPropertiesConfAccess.assertEquals((String)"level: LOAD_DEBUG2: bad string expr", (Object)String.valueOf(BasicLevel.DEBUG + 2), (Object)((LevelImpl)le).getStringValue());
        Handler h = null;
        h = this.hf.getHandler("myhandler1");
        TestPropertiesConfAccess.assertNotNull((String)"handler: myhandler1: undefined", (Object)h);
        TestPropertiesConfAccess.assertEquals((String)"handler: myhandler1: bad type", (byte)2, (byte)h.getType());
        TestPropertiesConfAccess.assertEquals((String)"handler: myhandler1: bad output", (Object)"System.out", (Object)h.getAttribute("output"));
        TestPropertiesConfAccess.assertEquals((String)"handler: myhandler1: bad pattern", (Object)"%m%n", (Object)h.getAttribute("pattern"));
        h = this.hf.getHandler("test.load.myhandler2");
        TestPropertiesConfAccess.assertNotNull((String)"handler: test.load.myhandler2: undefined", (Object)h);
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad type", (byte)1, (byte)h.getType());
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad output", (Object)"myhandler2.log", (Object)h.getAttribute("output"));
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad pattern", (Object)"=> %m%n", (Object)h.getAttribute("pattern"));
        h = this.hf.getHandler("test.load.myhandler3");
        TestPropertiesConfAccess.assertNotNull((String)"handler: test.load.myhandler3: undefined", (Object)h);
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler3: bad type", (byte)3, (byte)h.getType());
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad output", (Object)"myhandler3.log", (Object)h.getAttribute("output"));
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad pattern", (Object)"-> %m%n", (Object)h.getAttribute("pattern"));
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad file number", (Object)"2", (Object)h.getAttribute("fileNumber"));
        TestPropertiesConfAccess.assertEquals((String)"handler: test.load.myhandler2: bad max size", (Object)"20", (Object)h.getAttribute("maxSize"));
        TopicalLogger l = null;
        l = (TopicalLogger)this.lf.getLogger("test.load.bar");
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.bar: bad level", (int)BasicLevel.DEBUG, (int)l.getCurrentIntLevel());
        l = (TopicalLogger)this.lf.getLogger("test.load.foo");
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.foo: bad level", (int)(BasicLevel.DEBUG + 1), (int)l.getCurrentIntLevel());
        l = (TopicalLogger)this.lf.getLogger("test.load.foo3");
        Handler[] hs = l.getHandler();
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo3: handler list is null", (Object)hs);
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.foo3: handler list is empty", (int)1, (int)hs.length);
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.foo3: bad handler", (Object)this.hf.getHandler("myhandler1"), (Object)hs[0]);
        l = (TopicalLogger)this.lf.getLogger("test.load.foo4");
        hs = l.getHandler();
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo4: handler list is null", (Object)hs);
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.foo4: handler list is empty", (int)2, (int)hs.length);
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo4: handler element 0 is null", (Object)hs[0]);
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo4: handler element 1 is null", (Object)hs[1]);
        if (!hs[0].equals(this.hf.getHandler("test.load.myhandler2")) && !hs[1].equals(this.hf.getHandler("test.load.myhandler2"))) {
            TestPropertiesConfAccess.fail((String)"logger: test.load.foo4: 'test.load.myhandler2' handler not found");
        }
        if (!hs[0].equals(this.hf.getHandler("test.load.myhandler3")) && !hs[1].equals(this.hf.getHandler("test.load.myhandler3"))) {
            TestPropertiesConfAccess.fail((String)"logger: test.load.foo4: 'test.load.myhandler3' handler not found");
        }
        l = (TopicalLogger)this.lf.getLogger("test.load.foo2");
        String[] ts = l.getTopic();
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo2: topic list is null", (Object)ts);
        TestPropertiesConfAccess.assertEquals((String)"logger: test.load.foo2: bad topic list size", (int)3, (int)ts.length);
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo2: topic element 0 is null", (Object)ts[0]);
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo2: topic element 1 is null", (Object)ts[1]);
        TestPropertiesConfAccess.assertNotNull((String)"logger: test.load.foo2: topic element 2 is null", (Object)ts[2]);
        if (!(ts[0].equals("test.load.foo2") || ts[1].equals("test.load.foo2") || ts[2].equals("test.load.foo2"))) {
            TestPropertiesConfAccess.fail((String)"logger: test.load.foo2: main topic not found");
        }
        if (!(ts[0].equals("org.ow.foo") || ts[1].equals("org.ow.foo") || ts[2].equals("org.ow.foo"))) {
            TestPropertiesConfAccess.fail((String)"logger: test.load.foo2: 'org.ow.foo' topic not found");
        }
        if (!(ts[0].equals("org.ow.foo2") || ts[1].equals("org.ow.foo2") || ts[2].equals("org.ow.foo2"))) {
            TestPropertiesConfAccess.fail((String)"logger: test.load.foo2: 'org.ow.foo2' topic not found");
        }
    }

    public void checkExist(Properties p, Set s, String key, String value, String msg) {
        boolean t = s.contains(key);
        if (!t) {
            // empty if block
        }
        TestPropertiesConfAccess.assertTrue((String)(msg + ": not found"), (boolean)t);
        TestPropertiesConfAccess.assertEquals((String)(msg + ": (" + key + ")bad value"), (Object)value, (Object)p.getProperty(key));
    }

    public void checkUnExist(Set s, String key, String msg) {
        TestPropertiesConfAccess.assertTrue((String)(msg + ": found"), (!s.contains(key) ? 1 : 0) != 0);
    }

    public void checkBeginExist(Properties p, String key, String value, String msg) {
        boolean found = false;
        this.debug("checkBeginExist( key=" + key + " / value=" + value);
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String cur = (String)e.nextElement();
            this.debug("  cur=" + cur + " / val=" + p.getProperty(cur, ""));
            if (!cur.startsWith(key) || !p.getProperty(cur, "").equals(value)) continue;
            if (found) {
                TestPropertiesConfAccess.fail((String)(msg + "duplicated value: " + value));
                continue;
            }
            found = true;
        }
        TestPropertiesConfAccess.assertTrue((String)(msg + ": not found"), (boolean)found);
    }

    public void printProperties(Properties p) {
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> me = it.next();
            System.out.println(me.getKey() + "=" + me.getValue());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

