/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;

public class MonologFormatter
extends Formatter {
    private static final int PATTERN_ID_LEVEL = -100;
    private static final int PATTERN_ID_TOPIC = -200;
    private static final int PATTERN_ID_DATE = -300;
    private static final int PATTERN_ID_THREAD = -400;
    private static final int PATTERN_ID_MESSAGE = -500;
    private static final int PATTERN_ID_METHOD = -600;
    private static final int PATTERN_ID_OBJECT = -700;
    private static final int PATTERN_ID_LINE_NUMBER = -800;
    private static final int PATTERN_ID_NEW_LINE = -900;
    private static final int PATTERN_ID_INTERVAL = 100;
    private static final String TOKENS = "{}ltdhmMOL%n";
    String strPattern;
    int[] pattern;
    String[] strings;

    public MonologFormatter() {
    }

    public MonologFormatter(String strPattern) {
        this.setPattern(strPattern);
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setPattern(String p) {
        MonologFormatter.debug("Pattern=" + p);
        this.strPattern = p;
        if (this.strPattern == null) {
            this.pattern = new int[0];
        } else {
            StringTokenizer st = new StringTokenizer(p, TOKENS, true);
            ArrayList<Object> sections = new ArrayList<Object>();
            boolean isPrefix = false;
            boolean isObject = false;
            boolean isInSubObject = false;
            int subObjectNumber = 1;
            block14: while (st.hasMoreElements()) {
                String token = st.nextToken();
                MonologFormatter.debug("token=<" + token + ">");
                if (isObject && token.equals("{")) {
                    isInSubObject = true;
                    isObject = false;
                }
                if (token.length() == 1) {
                    char c = token.charAt(0);
                    switch (c) {
                        case '{': {
                            if (isInSubObject) continue block14;
                            this.addSection(sections, token);
                            break;
                        }
                        case '}': {
                            if (isInSubObject) {
                                int old = (Integer)sections.get(sections.size() - 1);
                                sections.set(sections.size() - 1, new Integer(old - subObjectNumber));
                                isInSubObject = false;
                                break;
                            }
                            this.addSection(sections, token);
                            break;
                        }
                        case '%': {
                            if (isPrefix) {
                                sections.add(String.valueOf('%'));
                            }
                            isPrefix = !isPrefix;
                            break;
                        }
                        case 'l': {
                            isPrefix = this.treatPattern(sections, token, -100, isPrefix);
                            break;
                        }
                        case 't': {
                            isPrefix = this.treatPattern(sections, token, -200, isPrefix);
                            break;
                        }
                        case 'd': {
                            isPrefix = this.treatPattern(sections, token, -300, isPrefix);
                            break;
                        }
                        case 'h': {
                            isPrefix = this.treatPattern(sections, token, -400, isPrefix);
                            break;
                        }
                        case 'm': {
                            isPrefix = this.treatPattern(sections, token, -500, isPrefix);
                            break;
                        }
                        case 'M': {
                            isPrefix = this.treatPattern(sections, token, -600, isPrefix);
                            break;
                        }
                        case 'O': {
                            isPrefix = this.treatPattern(sections, token, -700, isPrefix);
                            isObject = true;
                            break;
                        }
                        case 'L': {
                            isPrefix = this.treatPattern(sections, token, -800, isPrefix);
                            break;
                        }
                        case 'n': {
                            isPrefix = this.treatPattern(sections, token, -900, isPrefix);
                            break;
                        }
                        default: {
                            if (isInSubObject) {
                                subObjectNumber = Integer.parseInt(token);
                                break;
                            }
                            this.addSection(sections, token);
                            break;
                        }
                    }
                    continue;
                }
                if (isObject) continue;
                if (isInSubObject) {
                    subObjectNumber = Integer.parseInt(token);
                    continue;
                }
                this.addSection(sections, token);
            }
            this.pattern = new int[sections.size()];
            MonologFormatter.debug("building pattern array...");
            MonologFormatter.debug("nb of pattern:" + this.pattern.length);
            ArrayList stringList = new ArrayList(sections.size());
            int cpt = 0;
            for (int i = 0; i < this.pattern.length; ++i) {
                Object o = sections.get(i);
                if (o instanceof String) {
                    MonologFormatter.debug("add current pattern into strings: [" + cpt + ", " + o + "]");
                    stringList.add(o);
                    this.pattern[i] = cpt++;
                    continue;
                }
                if (!(o instanceof Integer)) continue;
                MonologFormatter.debug("add current pattern as negative number:" + o);
                this.pattern[i] = (Integer)o;
            }
            this.strings = stringList.toArray(new String[cpt]);
            MonologFormatter.debug("nb of string:" + this.strings.length);
        }
    }

    private boolean treatPattern(List sections, String token, int tokenId, boolean isPrefix) {
        MonologFormatter.debug("treatPttern(" + tokenId + "):" + " isPrefix=" + isPrefix + " token=" + token + " sections=" + sections);
        if (isPrefix) {
            sections.add(new Integer(tokenId));
            return false;
        }
        this.addSection(sections, token);
        return isPrefix;
    }

    private void addSection(List sections, String s) {
        int size = sections.size();
        if (size == 0) {
            MonologFormatter.debug("addSection(" + s + ", " + sections + "): first elem");
            sections.add(s);
        } else {
            Object last = sections.get(size - 1);
            if (last instanceof String) {
                sections.set(size - 1, last + s);
                MonologFormatter.debug("addSection(" + s + ", " + sections + "): concat: " + sections.get(size - 1));
            } else {
                MonologFormatter.debug("addSection(" + s + ", " + sections + "): new elem");
                sections.add(s);
            }
        }
    }

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String[] ctx = null;
        block11: for (int i = 0; i < this.pattern.length; ++i) {
            int p = this.pattern[i];
            MonologFormatter.debug("format: pattern=" + p);
            switch (p) {
                case -100: {
                    sb.append(record.getLevel().getName());
                    continue block11;
                }
                case -200: {
                    sb.append(record.getLoggerName());
                    continue block11;
                }
                case -300: {
                    sb.append(record.getMillis());
                    continue block11;
                }
                case -400: {
                    sb.append(record.getThreadID());
                    continue block11;
                }
                case -500: {
                    sb.append(record.getMessage());
                    continue block11;
                }
                case -600: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[1]);
                    continue block11;
                }
                case -700: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[0]);
                    continue block11;
                }
                case -800: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[2]);
                    continue block11;
                }
                case -900: {
                    sb.append("\n");
                    continue block11;
                }
                default: {
                    if (p < 0) {
                        if (ctx == null) {
                            ctx = MonologFormatter.getContext();
                        }
                        if (p <= -800 || p >= -700) continue block11;
                        p = -700 - p;
                        String res = ctx[0];
                        if (p == 1) {
                            int idx = res.lastIndexOf(46);
                            if (idx != -1) {
                                res = res.substring(idx + 1);
                            }
                        } else if (p == 0) {
                            // empty if block
                        }
                        sb.append(res);
                        continue block11;
                    }
                    if (p >= this.strings.length) {
                        System.err.println("ERROR: String identifier unknown: " + p);
                        continue block11;
                    }
                    sb.append(this.strings[p]);
                }
            }
        }
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            sb.append(sw.getBuffer());
        }
        return sb.toString();
    }

    private static void debug(String m) {
        AbstractFactory.debug(m);
    }

    public static String[] getContext() {
        int removeTopStack = 10;
        Throwable t = new Throwable().fillInStackTrace();
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String m = sw.getBuffer().toString();
        int fin = 0;
        int deb = -1;
        for (int i = 0; i < removeTopStack; ++i) {
            deb = m.indexOf("\n", deb + 1);
        }
        deb = m.indexOf("at ", deb);
        fin = m.indexOf("\n", deb);
        m = m.substring(deb + 3, fin);
        deb = m.indexOf("(");
        fin = m.indexOf(":");
        String[] res = new String[3];
        res[2] = fin == -1 ? "unknown" : m.substring(fin + 1, m.length() - 1);
        m = m.substring(0, deb);
        fin = m.indexOf(46);
        res[0] = m.substring(0, fin);
        res[1] = m.substring(fin + 1);
        return res;
    }
}

