/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.channel.IPChannelInAttributeController;
import org.objectweb.dream.message.codec.MessageCodec;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class AbstractTCPChannelInImpl
extends AbstractComponent
implements IPChannelInAttributeController {
    private static final int SERVER_SOCKET_OPEN_RETRY = 20;
    protected Push outPushItf;
    protected MessageCodec messageCodecItf;
    protected int portNum = -1;
    protected int openRetry = 20;

    public int getListeningPort() {
        return this.portNum;
    }

    public void setListeningPort(int port) throws IllegalLifeCycleException {
        if (this.portNum != port && this.fcState.equals("STARTED")) {
            throw new IllegalLifeCycleException("cannot change listening port when the component is started");
        }
        this.portNum = port;
    }

    public int getOpenRetry() {
        return this.openRetry;
    }

    public void setOpenRetry(int retry) {
        this.openRetry = retry;
    }

    public String[] listFc() {
        return new String[]{"out-push", "message-codec"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("out-push")) {
            this.outPushItf = (Push)serverItf;
        } else if (clientItfName.equals("message-codec")) {
            this.messageCodecItf = (MessageCodec)serverItf;
        }
    }

    protected void sendAck(Socket socket) throws IOException {
    }

    protected ServerSocket createServerSocket(int port) throws IOException {
        int i = 0;
        while (true) {
            try {
                return new ServerSocket(port);
            }
            catch (BindException exc) {
                if (i > this.openRetry) {
                    throw exc;
                }
                try {
                    Thread.sleep(i * 250);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    protected void setSocketOption(Socket sock) throws SocketException {
        sock.setTcpNoDelay(true);
        sock.setSoTimeout(0);
        sock.setSoLinger(true, 60);
    }
}

