/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.channel.ChannelOutAttributeController;
import org.objectweb.dream.message.codec.MessageCodec;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractTCPChannelOutImpl
extends AbstractComponent
implements Push,
ChannelOutAttributeController {
    protected int cnxRetry = 5;
    protected MessageManager messageManagerItf;
    protected MessageCodec messageCodecItf;

    public int getConnectionRetry() {
        return this.cnxRetry;
    }

    public void setConnectionRetry(int retry) {
        this.cnxRetry = retry;
    }

    public String[] listFc() {
        return new String[]{"message-manager", "message-codec"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        } else if (clientItfName.equals("message-codec")) {
            this.messageCodecItf = (MessageCodec)serverItf;
        }
    }

    protected Socket connectSocket(InetAddress addr, int port) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.logger.log(BasicLevel.DEBUG, (Object)"try to connect");
                Socket sock = new Socket(addr, port);
                this.setSocketOption(sock);
                this.logger.log(BasicLevel.DEBUG, (Object)"connected");
                return sock;
            }
            catch (IOException exc) {
                this.logger.log(BasicLevel.WARN, (Object)("connection failed on address " + addr));
                if (i > this.cnxRetry) {
                    throw exc;
                }
                try {
                    Thread.sleep(i * 250);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    protected void closeSocket(Socket out) throws IOException {
        out.close();
    }

    protected void setSocketOption(Socket sock) throws SocketException {
        sock.setTcpNoDelay(true);
        sock.setSoTimeout(0);
        sock.setSoLinger(true, 60);
    }
}

