/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.channel.CachingIPSocketManagerAttributeController;
import org.objectweb.dream.channel.IPSocketManager;
import org.objectweb.dream.channel.SocketState;
import org.objectweb.dream.util.Error;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class CachingIPSocketManagerImpl
extends AbstractComponent
implements IPSocketManager,
CachingIPSocketManagerAttributeController {
    public static final String DELEGATE_IP_SOCKET_MANAGER = "delegate-ip-socket-manager";
    protected CacheEntry reusableKey = new CacheEntry();
    protected Map cache = new HashMap();
    protected Map reversCache = new HashMap();
    protected CacheEntry lruHead = null;
    protected CacheEntry lruTail = null;
    protected int nbMaxSocket;
    protected IPSocketManager delegateSocketManagerItf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketState getSocket(InetAddress address, int port) throws IOException {
        CacheEntry ce;
        Map map = this.cache;
        synchronized (map) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("get socket in cache for " + address + ":" + port));
            }
            this.reusableKey.inetAddress = address;
            this.reusableKey.port = port;
            ce = (CacheEntry)this.cache.get(this.reusableKey);
            if (ce != null) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Socket found in cache");
                if (ce.inUse) {
                    throw new IOException("Socket in already in use");
                }
                if (ce.socketState.isClosed()) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Socket is closed");
                    ce.cacheRemove();
                }
                ce.inUse = true;
                ce.lruSetAtfirst();
                return ce.socketState;
            }
            if (this.cache.size() >= this.nbMaxSocket) {
                if (this.lruTail.inUse) {
                    throw new IOException("Can't add new socket, cache full and every sockets are in use.");
                }
                this.lruTail.cacheRemove();
            }
            ce = new CacheEntry();
            ce.inetAddress = address;
            ce.port = port;
            ce.inUse = true;
            this.cache.put(ce, ce);
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Create new socket for " + address + ":" + port));
        }
        SocketState socketState = this.delegateSocketManagerItf.getSocket(address, port);
        Map map2 = this.cache;
        synchronized (map2) {
            this.logger.log(BasicLevel.DEBUG, (Object)"new socket created.");
            ce.socketState = socketState;
            this.reversCache.put(socketState, ce);
            return socketState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSocket(SocketState socketState) {
        Map map = this.cache;
        synchronized (map) {
            CacheEntry ce = (CacheEntry)this.reversCache.get(socketState);
            if (ce == null) {
                throw new IllegalArgumentException("Unknown SocketState");
            }
            ce.inUse = false;
        }
    }

    public int getNbMaxSocket() {
        return this.nbMaxSocket;
    }

    public void setNbMaxSocket(int nbMaxSocket) {
        this.nbMaxSocket = nbMaxSocket;
    }

    public String[] listFc() {
        return new String[]{DELEGATE_IP_SOCKET_MANAGER};
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals(DELEGATE_IP_SOCKET_MANAGER)) {
            this.delegateSocketManagerItf = (IPSocketManager)serverItf;
        }
    }

    protected class CacheEntry {
        protected InetAddress inetAddress;
        protected int port;
        protected SocketState socketState;
        protected CacheEntry next = null;
        protected CacheEntry prev = null;
        protected boolean inUse = false;

        protected CacheEntry() {
        }

        protected void cacheRemove() {
            if (CachingIPSocketManagerImpl.this.cache.remove(this) == null) {
                Error.bug(CachingIPSocketManagerImpl.this.logger);
            }
            if (CachingIPSocketManagerImpl.this.reversCache.remove(this.socketState) == null) {
                Error.bug(CachingIPSocketManagerImpl.this.logger);
            }
            this.lruRemove();
        }

        protected void lruRemove() {
            if (this.next == null) {
                if (this.prev == null) {
                    CachingIPSocketManagerImpl.this.lruHead = null;
                    CachingIPSocketManagerImpl.this.lruTail = null;
                } else {
                    CachingIPSocketManagerImpl.this.lruTail = this.prev;
                    CachingIPSocketManagerImpl.this.lruTail.next = null;
                }
            } else {
                this.next.prev = this.prev;
                if (this.prev == null) {
                    CachingIPSocketManagerImpl.this.lruHead = this.next;
                } else {
                    this.prev.next = this.next;
                }
            }
            this.next = null;
            this.prev = null;
        }

        protected void lruSetAtfirst() {
            if (this.prev == null) {
                return;
            }
            this.prev.next = this.next;
            if (this.next == null) {
                CachingIPSocketManagerImpl.this.lruTail = this.prev;
            } else {
                this.next.prev = this.prev;
            }
            CachingIPSocketManagerImpl.this.lruHead.prev = this;
            this.next = CachingIPSocketManagerImpl.this.lruHead;
            this.prev = null;
            CachingIPSocketManagerImpl.this.lruHead = this;
        }

        protected void lruAddAtFirst() {
            if (CachingIPSocketManagerImpl.this.lruHead == null) {
                CachingIPSocketManagerImpl.this.lruHead = this;
                CachingIPSocketManagerImpl.this.lruTail = this;
                return;
            }
            CachingIPSocketManagerImpl.this.lruHead.prev = this;
            this.next = CachingIPSocketManagerImpl.this.lruHead;
            this.prev = null;
            CachingIPSocketManagerImpl.this.lruHead = this;
        }

        public boolean equals(Object obj) {
            CacheEntry key = (CacheEntry)obj;
            return (this.inetAddress == null ? key.inetAddress == null : this.inetAddress.equals(key.inetAddress)) && this.port == key.port;
        }

        public int hashCode() {
            return this.inetAddress == null ? this.inetAddress.hashCode() + this.port : this.port;
        }
    }
}

