/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.activity.task;

import java.util.Map;
import org.objectweb.dream.control.activity.task.IllegalTaskException;
import org.objectweb.dream.control.activity.task.NoSuchTaskException;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.control.activity.task.TaskActivationController;
import org.objectweb.dream.control.activity.task.TaskActivationStoppedListener;
import org.objectweb.dream.control.activity.task.TaskManagerController;
import org.objectweb.dream.control.activity.task.TaskStoppedListener;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class BasicTaskActivationMixin
implements TaskActivationController {
    public Logger _this_weaveableTCLogger;
    public Map _this_taskRegistrationHints;
    public Map _this_taskControls;
    public BindingController _this_weaveableBC;

    public void activateTask(Task task) throws NoSuchTaskException, IllegalTaskException {
        Object taskControl;
        if (!this._this_taskRegistrationHints.containsKey(task)) {
            throw new NoSuchTaskException(task);
        }
        if (this._this_taskControls.containsKey(task)) {
            return;
        }
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"register a task");
        Map hints = (Map)this._this_taskRegistrationHints.get(task);
        TaskManagerController tmc = this.getTaskManagerBinding();
        try {
            taskControl = tmc.registerTask(task, hints);
        }
        catch (Exception e) {
            throw new IllegalTaskException(task, "Unable to register component", e);
        }
        this._this_taskControls.put(task, taskControl);
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"task registered");
    }

    public void deactivateTask(Task task) throws NoSuchTaskException, IllegalTaskException {
        if (!this._this_taskRegistrationHints.containsKey(task)) {
            throw new NoSuchTaskException(task);
        }
        if (!this._this_taskControls.containsKey(task)) {
            return;
        }
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"deactivate a task");
        try {
            this.getTaskManagerBinding().unregisterTask(task);
        }
        catch (Exception e) {
            throw new IllegalTaskException(task, "Unable to unregister component", e);
        }
        this._this_taskControls.remove(task);
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"task deactivated");
    }

    public void deactivateTask(Task task, TaskStoppedListener taskStoppedListener) throws NoSuchTaskException, IllegalTaskException {
        if (!this._this_taskRegistrationHints.containsKey(task)) {
            throw new NoSuchTaskException(task);
        }
        if (!this._this_taskControls.containsKey(task)) {
            return;
        }
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"deactivate a task");
        try {
            this.getTaskManagerBinding().interruptTask(task, new TaskActivationStoppedListener(taskStoppedListener, this._this_taskControls));
        }
        catch (Exception e) {
            throw new IllegalTaskException(task, "Unable to unregister component", e);
        }
        this._this_taskControls.remove(task);
        this._this_weaveableTCLogger.log(BasicLevel.DEBUG, (Object)"task deactivated");
    }

    private TaskManagerController getTaskManagerBinding() throws IllegalTaskException {
        try {
            return (TaskManagerController)this._this_weaveableBC.lookupFc("task-manager");
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalTaskException(null, "This component has no task-manager client interface", null);
        }
    }
}

