/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.lifecycle;

import org.objectweb.dream.control.activity.task.IllegalTaskException;
import org.objectweb.dream.control.activity.task.NoSuchTaskException;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.control.activity.task.TaskActivationController;
import org.objectweb.dream.control.activity.task.TaskController;
import org.objectweb.dream.control.activity.task.TaskStoppedListener;
import org.objectweb.dream.util.Error;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class ActivityLifeCycleMixin
implements TaskStoppedListener {
    protected int fcNbStoppingTask;
    protected LifeCycleCoordinator fcActivityCoordinator;
    public Component _this_weaveableC;
    public Logger _this_weaveableLCCLogger;
    public TaskController _this_weaveableTC;
    public TaskActivationController _this_weaveableTAC;

    private ActivityLifeCycleMixin() {
    }

    public synchronized boolean setFcStarted() throws IllegalLifeCycleException {
        if (!this._super_setFcStarted()) {
            return false;
        }
        Task[] tasks = this._this_weaveableTC.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            if (this._this_weaveableLCCLogger.isLoggable(BasicLevel.DEBUG)) {
                this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)("activate task " + tasks[i]));
            }
            try {
                this._this_weaveableTAC.activateTask(tasks[i]);
                continue;
            }
            catch (NoSuchTaskException e) {
                Error.bug(this._this_weaveableLCCLogger, e);
                continue;
            }
            catch (IllegalTaskException e) {
                throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Error while registering task");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        Task[] tasks = this._this_weaveableTC.getTasks();
        ActivityLifeCycleMixin activityLifeCycleMixin = this;
        synchronized (activityLifeCycleMixin) {
            this.fcNbStoppingTask += tasks.length;
            this.fcActivityCoordinator = coordinator;
            for (int i = 0; i < tasks.length; ++i) {
                if (this._this_weaveableLCCLogger.isLoggable(BasicLevel.DEBUG)) {
                    this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)("interrupt task " + tasks[i]));
                }
                try {
                    this._this_weaveableTAC.deactivateTask(tasks[i], this);
                    continue;
                }
                catch (NoSuchTaskException e) {
                    Error.bug(this._this_weaveableLCCLogger, e);
                    continue;
                }
                catch (IllegalTaskException e) {
                    throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Error while unregistering task");
                }
            }
        }
        this._super_setFcStopping(coordinator);
    }

    public boolean checkInactivity() {
        return this.fcNbStoppingTask == 0 && this._super_checkInactivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStopped(Task task) {
        ActivityLifeCycleMixin activityLifeCycleMixin = this;
        synchronized (activityLifeCycleMixin) {
            if (this._this_weaveableLCCLogger.isLoggable(BasicLevel.DEBUG)) {
                this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)("task stopped" + task));
            }
            --this.fcNbStoppingTask;
            this._this_isInactivated(this.fcActivityCoordinator);
        }
    }

    public abstract boolean _super_setFcStarted() throws IllegalLifeCycleException;

    public abstract void _super_setFcStopping(LifeCycleCoordinator var1) throws IllegalLifeCycleException;

    public abstract boolean _super_checkInactivity();

    public abstract boolean _this_isInactivated(LifeCycleCoordinator var1);
}

