/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message;

import java.util.Iterator;
import java.util.LinkedList;
import org.objectweb.dream.message.AbstractExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;

public class BasicExtensibleMessage
extends AbstractExtensibleMessage {
    LinkedList subMessages = new LinkedList();
    Message[] subMessagesArray = null;
    MessageType[] subMessageTypesArray = null;

    public BasicExtensibleMessage(short messageManagerId) {
        this.messageManagerId = messageManagerId;
    }

    public void addSubMessage(Message message) {
        if (this.subMessages.add(message)) {
            this.subMessagesArray = null;
            this.subMessageTypesArray = null;
        }
    }

    public boolean removeSubMessage(Message msg) {
        boolean removed = this.subMessages.remove(msg);
        if (removed) {
            this.subMessagesArray = null;
            this.subMessageTypesArray = null;
        }
        return removed;
    }

    public Iterator getSubMessageIterator() {
        return this.subMessages.iterator();
    }

    public Message[] getSubMessages() {
        if (this.subMessagesArray == null) {
            this.subMessagesArray = this.subMessages.isEmpty() ? Message.EMPTY_MESSAGE_ARRAY : this.subMessages.toArray(Message.EMPTY_MESSAGE_ARRAY);
        }
        return this.subMessagesArray;
    }

    public MessageType[] getSubMessageTypes() {
        if (this.subMessageTypesArray == null) {
            if (this.subMessages.isEmpty()) {
                this.subMessageTypesArray = MessageType.EMPTY_MESSAGE_TYPE_ARRAY;
            } else {
                this.subMessageTypesArray = new MessageType[this.subMessages.size()];
                Iterator iter = this.getSubMessageIterator();
                int i = 0;
                while (iter.hasNext()) {
                    Message message = (Message)iter.next();
                    this.subMessageTypesArray[i] = message.getMessageType();
                    ++i;
                }
            }
        }
        return this.subMessageTypesArray;
    }

    public Iterator getSubMessageTypesIterator() {
        return new SubMessageTypeIterator();
    }

    public boolean isSubTypeOf(MessageType t) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private class SubMessageTypeIterator
    implements Iterator {
        Iterator messageIterator;

        private SubMessageTypeIterator() {
            this.messageIterator = BasicExtensibleMessage.this.getSubMessageIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.messageIterator.hasNext();
        }

        public Object next() {
            return ((Message)this.messageIterator.next()).getMessageType();
        }
    }
}

