/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.objectweb.dream.message.ChunkAlreadyExistsException;
import org.objectweb.dream.message.ChunkType;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.util.EmptyIterator;
import org.objectweb.dream.util.EmptyStringArray;

public class BasicMessageType
implements MessageType,
EmptyStringArray {
    public static final MessageType EMPTY_MESSAGE_TYPE = new BasicMessageType();
    protected Hashtable chunkTypes = null;
    protected LinkedList subMessageTypes = null;
    protected String[] chkNames = null;
    protected MessageType[] subMessageTypesArray = null;

    protected BasicMessageType() {
    }

    public BasicMessageType(String[] chkNames, ChunkType[] chkTypes, MessageType[] msgTypes) throws ChunkAlreadyExistsException {
        int i;
        ChunkAlreadyExistsException chunkAlreadyExistException = null;
        if (chkNames != null) {
            if (chkNames.length != chkTypes.length) {
                throw new IllegalArgumentException("chkNames and chkTypes do not have the same length");
            }
            for (i = 0; i < chkNames.length; ++i) {
                try {
                    this.addChunkType(chkNames[i], chkTypes[i]);
                    continue;
                }
                catch (ChunkAlreadyExistsException e) {
                    chunkAlreadyExistException = e;
                }
            }
        }
        if (msgTypes != null) {
            for (i = 0; i < msgTypes.length; ++i) {
                this.addSubMessageType(msgTypes[i]);
            }
        }
        if (chunkAlreadyExistException != null) {
            throw chunkAlreadyExistException;
        }
    }

    public BasicMessageType(String chkName, ChunkType chkType) {
        this.chunkTypes = new Hashtable();
        this.chunkTypes.put(chkName, chkType);
    }

    public BasicMessageType(String chkName1, ChunkType chkType1, String chkName2, ChunkType chkType2) throws ChunkAlreadyExistsException {
        this.addChunkType(chkName1, chkType1);
        this.addChunkType(chkName2, chkType2);
    }

    public ChunkType getChunkType(String name) {
        if (this.chunkTypes == null) {
            return null;
        }
        return (ChunkType)this.chunkTypes.get(name);
    }

    public String[] getChunkNames() {
        if (this.chkNames == null) {
            this.chkNames = this.chunkTypes == null ? EmptyStringArray.EMPTY_STRING_ARRAY : this.chunkTypes.keySet().toArray(EmptyStringArray.EMPTY_STRING_ARRAY);
        }
        return this.chkNames;
    }

    public Iterator getChunkNamesIterator() {
        if (this.chunkTypes == null) {
            return EmptyIterator.INSTANCE;
        }
        return this.chunkTypes.keySet().iterator();
    }

    public MessageType[] getSubMessageTypes() {
        if (this.subMessageTypesArray == null) {
            this.subMessageTypesArray = this.subMessageTypes == null ? MessageType.EMPTY_MESSAGE_TYPE_ARRAY : this.subMessageTypes.toArray(MessageType.EMPTY_MESSAGE_TYPE_ARRAY);
        }
        return this.subMessageTypesArray;
    }

    public Iterator getSubMessageTypesIterator() {
        if (this.subMessageTypes == null) {
            return EmptyIterator.INSTANCE;
        }
        return this.subMessageTypes.iterator();
    }

    public boolean isEmpty() {
        return this.chunkTypes == null && this.subMessageTypes == null;
    }

    public boolean isSubTypeOf(MessageType t) {
        if (t.isEmpty()) {
            return true;
        }
        String[] tChkNames = t.getChunkNames();
        for (int i = 0; i < tChkNames.length; ++i) {
            String name = tChkNames[i];
            ChunkType thisChkType = (ChunkType)this.chunkTypes.get(name);
            if (thisChkType == null) {
                return false;
            }
            ChunkType tChkType = t.getChunkType(name);
            if (tChkType == null) {
                return false;
            }
            if (thisChkType.isSubTypeOf(tChkType)) continue;
            return false;
        }
        return true;
    }

    public void addChunkType(String chunkName, ChunkType chunkType) throws ChunkAlreadyExistsException {
        ChunkType previousChunk;
        if (this.chunkTypes == null) {
            this.chunkTypes = new Hashtable();
        }
        if ((previousChunk = this.chunkTypes.put(chunkName, chunkType)) != null) {
            this.chunkTypes.put(chunkName, chunkType);
            throw new ChunkAlreadyExistsException("Chunk type with the same name already exist");
        }
        this.chkNames = null;
    }

    public void addSubMessageType(MessageType msgType) {
        if (this.subMessageTypes == null) {
            this.subMessageTypes = new LinkedList();
        }
        this.subMessageTypes.add(msgType);
        this.subMessageTypesArray = null;
    }

    public ChunkType removeChunkType(String name) {
        if (this.chunkTypes == null) {
            return null;
        }
        ChunkType t = (ChunkType)this.chunkTypes.remove(name);
        if (t != null) {
            this.chkNames = null;
            if (this.chunkTypes.isEmpty()) {
                this.chunkTypes = null;
            }
        }
        return t;
    }

    public boolean removeSubMessageType(MessageType msgType) {
        if (this.subMessageTypes == null) {
            return false;
        }
        if (this.subMessageTypes.remove(msgType)) {
            this.subMessageTypesArray = null;
            if (this.subMessageTypes.isEmpty()) {
                this.subMessageTypes = null;
            }
            return true;
        }
        return false;
    }
}

