/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.multiplexer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.InitializationException;
import org.objectweb.dream.Pull;
import org.objectweb.dream.Push;
import org.objectweb.dream.control.activity.Util;
import org.objectweb.dream.control.activity.task.AbstractTask;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.multiplexer.Attachment;
import org.objectweb.dream.multiplexer.PeriodicAttachment;
import org.objectweb.dream.multiplexer.PullPushMultiplexer;
import org.objectweb.dream.time.SetTimeStamp;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class PullPushPeriodicMultiplexerImpl
extends AbstractComponent
implements PullPushMultiplexer {
    protected ArrayList attachments;
    protected Map inputs;
    protected Map outputs;
    protected MessageManager messageManagerItf;
    protected SetTimeStamp setTimeStamp;
    protected int attachmentId = 0;
    private Task pumpTask = new PumpTask("pumpTask");

    public PullPushPeriodicMultiplexerImpl() {
        this.attachments = new ArrayList();
        this.inputs = new Hashtable();
        this.outputs = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment attach(String[] inputNames, Map[] inputContexts, String[] outputNames, Map[] outputContexts, Map parameters) throws NoSuchInterfaceException {
        long startingDate = 0L;
        if (parameters.get("startingDate") != null) {
            startingDate = (Long)parameters.get("startingDate");
        }
        long endDate = 0L;
        if (parameters.get("endDate") != null) {
            endDate = (Long)parameters.get("endDate");
        }
        long pullingFrequency = 0L;
        if (parameters.get("pullingFrequency") != null) {
            pullingFrequency = (Long)parameters.get("pullingFrequency");
        }
        Pull[] attachmentInputs = new Pull[this.inputs.size()];
        for (int i = 0; i < inputNames.length; ++i) {
            attachmentInputs[i] = (Pull)this.inputs.get(inputNames[i]);
        }
        Push[] attachmentOutputs = new Push[this.outputs.size()];
        for (int i = 0; i < outputNames.length; ++i) {
            attachmentOutputs[i] = (Push)this.outputs.get(outputNames[i]);
        }
        PeriodicAttachment attachment = new PeriodicAttachment(this.attachmentId++, inputNames, attachmentInputs, inputContexts, outputNames, attachmentOutputs, outputContexts, startingDate, pullingFrequency, endDate);
        ArrayList arrayList = this.attachments;
        synchronized (arrayList) {
            this.attachments.add(attachment);
            this.attachments.notifyAll();
        }
        return (Attachment)attachment.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Attachment attachment) {
        ArrayList arrayList = this.attachments;
        synchronized (arrayList) {
            ((PeriodicAttachment)attachment).setEndDate(System.currentTimeMillis());
            this.attachments.remove(attachment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Attachment attachment) {
        ArrayList arrayList = this.attachments;
        synchronized (arrayList) {
            this.attachments.remove(attachment);
            Attachment newAttachment = (Attachment)attachment.clone();
            Pull[] attachmentInputs = new Pull[this.inputs.size()];
            for (int i = 0; i < newAttachment.inputNames.length; ++i) {
                attachmentInputs[i] = (Pull)this.inputs.get(newAttachment.inputNames[i]);
            }
            Push[] attachmentOutputs = new Push[this.outputs.size()];
            for (int i = 0; i < newAttachment.outputNames.length; ++i) {
                attachmentOutputs[i] = (Push)this.outputs.get(newAttachment.outputNames[i]);
            }
            newAttachment.setInputs(attachmentInputs);
            newAttachment.setOutputs(attachmentOutputs);
            this.attachments.add(newAttachment);
        }
    }

    public ArrayList getAttachments() {
        ArrayList<Object> returnedAttachments = new ArrayList<Object>();
        Iterator iter = this.attachments.iterator();
        while (iter.hasNext()) {
            returnedAttachments.add(((PeriodicAttachment)iter.next()).clone());
        }
        return returnedAttachments;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.startsWith("out-push")) {
            this.outputs.put(clientItfName, serverItf);
        } else if (clientItfName.startsWith("in-pull")) {
            this.inputs.put(clientItfName, serverItf);
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        } else if (clientItfName.equals("set-time-stamp")) {
            this.setTimeStamp = (SetTimeStamp)serverItf;
        }
    }

    public synchronized void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.unbindFc(clientItfName);
        if (clientItfName.startsWith("out-push")) {
            this.outputs.remove(clientItfName);
        } else if (clientItfName.startsWith("in-pull")) {
            this.inputs.remove(clientItfName);
        }
    }

    public synchronized String[] listFc() {
        int size = this.outputs.size() + this.inputs.size() + 2;
        String[] tab = new String[size];
        this.outputs.keySet().toArray(tab);
        String[] inputsArr = new String[this.inputs.size()];
        this.inputs.keySet().toArray(inputsArr);
        int j = 0;
        for (int i = this.outputs.size(); i < this.outputs.size() + this.inputs.size(); ++i) {
            tab[i] = inputsArr[j];
            ++j;
        }
        tab[this.inputs.size() + this.outputs.size()] = "message-manager";
        tab[this.inputs.size() + this.outputs.size() + 1] = "set-time-stamp";
        return tab;
    }

    protected void initComponent(Component componentItf) throws InitializationException {
        super.initComponent(componentItf);
        try {
            Util.addTask(componentItf, this.pumpTask, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new InitializationException(e, componentItf, "Can't add task");
        }
    }

    private class PumpTask
    extends AbstractTask {
        public PumpTask(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(Object hints) throws InterruptedException {
            long nextWakeup = Long.MAX_VALUE;
            long currentTime = PullPushPeriodicMultiplexerImpl.this.setTimeStamp.setTimeStamp();
            ArrayList arrayList = PullPushPeriodicMultiplexerImpl.this.attachments;
            synchronized (arrayList) {
                int size = PullPushPeriodicMultiplexerImpl.this.attachments.size();
                for (int i = 0; i < size; ++i) {
                    PeriodicAttachment attachment = (PeriodicAttachment)PullPushPeriodicMultiplexerImpl.this.attachments.get(i);
                    long endDate = attachment.getEndDate();
                    if (endDate != 0L && endDate < currentTime) {
                        PullPushPeriodicMultiplexerImpl.this.attachments.remove(i);
                        --i;
                        --size;
                        continue;
                    }
                    if (attachment.getNextDeadline() <= currentTime) {
                        try {
                            Pull[] attachmentInputs = attachment.getInputs();
                            Map[] inputContexts = attachment.getInputContexts();
                            Push[] attachmentOutputs = attachment.getOutputs();
                            Map[] outputContexts = attachment.getOutputContexts();
                            for (int j = 0; j < attachmentInputs.length; ++j) {
                                Message m = attachmentInputs[j].pull(inputContexts[j]);
                                for (int k = 0; k < attachmentOutputs.length; ++k) {
                                    attachmentOutputs[k].push(m, outputContexts[k]);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            PullPushPeriodicMultiplexerImpl.this.attachments.remove(i);
                            --i;
                            --size;
                            continue;
                        }
                        attachment.setNextDeadline(currentTime + attachment.pullingFrequencyInMillis());
                    }
                    if (nextWakeup <= attachment.getNextDeadline()) continue;
                    nextWakeup = attachment.getNextDeadline();
                }
                if (nextWakeup == Long.MAX_VALUE) {
                    PullPushPeriodicMultiplexerImpl.this.attachments.wait();
                } else {
                    long timeToSleep = nextWakeup - currentTime;
                    if (timeToSleep > 0L) {
                        PullPushPeriodicMultiplexerImpl.this.attachments.wait(timeToSleep);
                    }
                }
            }
            return EXECUTE_AGAIN;
        }
    }
}

