/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.queue;

import java.util.LinkedList;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.InterruptedPushException;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.queue.BufferOverflowException;
import org.objectweb.dream.queue.PushQueueAttributeController;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractPushQueueImpl
extends AbstractComponent
implements Push,
PushQueueAttributeController {
    protected MessageManager messageManagerItf;
    protected LinkedList waitingList = new LinkedList();
    protected int maxCapacity;
    protected String overflowPolicy;

    public synchronized void push(Message message, Map context) throws PushException {
        if (this.handleOverflow()) {
            this.waitingList.add(message);
            this.notify();
        } else {
            this.messageManagerItf.deleteMessage(message);
        }
    }

    protected boolean handleOverflow() throws BufferOverflowException, InterruptedPushException {
        if (this.waitingList.size() == this.maxCapacity) {
            if (this.overflowPolicy == "block") {
                while (this.waitingList.size() == this.maxCapacity) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedPushException(e);
                    }
                }
            } else {
                if (this.overflowPolicy == "drop") {
                    this.logger.log(BasicLevel.INFO, (Object)"buffer overflow, drop new message");
                    return false;
                }
                if (this.overflowPolicy == "exception") {
                    throw new BufferOverflowException("Overflow in buffer");
                }
            }
        }
        return true;
    }

    public String getOverflowPolicy() {
        return this.overflowPolicy;
    }

    public synchronized void setOverflowPolicy(String policy) {
        if (policy.equals("block")) {
            this.overflowPolicy = "block";
        } else if (policy.equals("drop")) {
            this.overflowPolicy = "drop";
        } else if (policy.equals("exception")) {
            this.overflowPolicy = "exception";
        } else {
            throw new IllegalArgumentException("Unknown overflow policy : " + policy);
        }
    }

    public synchronized int getCurrentSize() {
        return this.waitingList.size();
    }

    public synchronized int getMaxCapacity() {
        return this.maxCapacity;
    }

    public synchronized void setMaxCapacity(int maxCapacity) {
        int previousCapacity = this.maxCapacity;
        this.maxCapacity = maxCapacity;
        if (this.overflowPolicy == "block" && maxCapacity > previousCapacity) {
            this.notifyAll();
        }
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }
}

