/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.util.Fractal;

public final class Util {
    public static final Object NULL_OBJECT = new Object();

    private Util() {
    }

    public static Component getComponentByName(ContentController cc, String name) {
        String[] compNames = name.split("/");
        ContentController contentController = cc;
        Component c = null;
        for (int i = 0; i < compNames.length; ++i) {
            c = null;
            Component[] comps = cc.getFcSubComponents();
            for (int j = 0; j < comps.length; ++j) {
                Component component = comps[j];
                try {
                    String tempName = Fractal.getNameController(component).getFcName();
                    if (!tempName.equals(compNames[i])) continue;
                    c = component;
                    cc = Fractal.getContentController(component);
                    break;
                }
                catch (NoSuchInterfaceException e) {
                    // empty catch block
                }
            }
            if (c != null) continue;
            return null;
        }
        return c;
    }

    public static void writeExternalByteArray(ObjectOutput out, byte[] array) throws IOException {
        if (array == null) {
            out.writeShort(-1);
        } else {
            int length = array.length;
            out.writeShort(length);
            for (int i = 0; i < length; ++i) {
                out.writeByte(array[i]);
            }
        }
    }

    public static byte[] readExternalByteArray(ObjectInput in) throws IOException {
        int length = in.readShort();
        if (length == -1) {
            return null;
        }
        byte[] toReturn = new byte[length];
        for (int i = 0; i < length; ++i) {
            toReturn[i] = in.readByte();
        }
        return toReturn;
    }

    public static void writeExternalIntArray(ObjectOutput out, int[] array) throws IOException {
        if (array == null) {
            out.writeShort(-1);
        } else {
            int length = array.length;
            out.writeShort(length);
            for (int i = 0; i < length; ++i) {
                out.writeInt(array[i]);
            }
        }
    }

    public static int[] readExternalIntArray(ObjectInput in) throws IOException {
        int length = in.readShort();
        if (length == -1) {
            return null;
        }
        int[] toReturn = new int[length];
        for (int i = 0; i < length; ++i) {
            toReturn[i] = in.readInt();
        }
        return toReturn;
    }

    public static void writeExternalLongArray(ObjectOutput out, long[] array) throws IOException {
        if (array == null) {
            out.writeShort(-1);
        } else {
            int length = array.length;
            out.writeShort(length);
            for (int i = 0; i < length; ++i) {
                out.writeLong(array[i]);
            }
        }
    }

    public static long[] readExternalLongArray(ObjectInput in) throws IOException {
        int length = in.readShort();
        if (length == -1) {
            return null;
        }
        long[] toReturn = new long[length];
        for (int i = 0; i < length; ++i) {
            toReturn[i] = in.readLong();
        }
        return toReturn;
    }
}

