/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.types.TypeInterface;

public class TypeBindingLoader
extends BindingLoader {
    void checkBinding(Binding binding, Interface fromItf, Interface toItf, Map context) throws ADLException {
        if (fromItf instanceof TypeInterface && toItf instanceof TypeInterface) {
            TypeInterface cItf = (TypeInterface)fromItf;
            TypeInterface sItf = (TypeInterface)toItf;
            if (binding.getFrom().startsWith("this.")) {
                if (!"server".equals(cItf.getRole())) {
                    throw new ADLException("Invalid binding: 'from' interface is not an internal client interface", (Node)((Object)binding));
                }
            } else if (!"client".equals(cItf.getRole())) {
                throw new ADLException("Invalid binding: 'from' interface is not a client interface", (Node)((Object)binding));
            }
            if (binding.getTo().startsWith("this.")) {
                if (!"client".equals(sItf.getRole())) {
                    throw new ADLException("Invalid binding: 'to' interface is not an internal server interface", (Node)((Object)binding));
                }
            } else if (!"server".equals(sItf.getRole())) {
                throw new ADLException("Invalid binding: 'to' interface is not a server interface", (Node)((Object)binding));
            }
            boolean cIsMandatory = true;
            if ("optional".equals(cItf.getContingency())) {
                cIsMandatory = false;
            }
            boolean sIsMandatory = true;
            if ("optional".equals(sItf.getContingency())) {
                sIsMandatory = false;
            }
            if (cIsMandatory && !sIsMandatory) {
                throw new ADLException("Invalid binding: binding from mandatory to optional interface", (Node)((Object)binding));
            }
            try {
                ClassLoader cl = this.getClassLoader(context);
                Class<?> cClass = cl.loadClass(cItf.getSignature());
                Class<?> sClass = cl.loadClass(sItf.getSignature());
                if (!cClass.isAssignableFrom(sClass)) {
                    throw new ADLException("Invalid binding: incompatible signatures", (Node)((Object)binding));
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    Interface getInterface(String name, Map itfs) {
        Interface itf = super.getInterface(name, itfs);
        if (itf == null) {
            for (String n : itfs.keySet()) {
                TypeInterface typeItf;
                String cardinality;
                itf = (Interface)itfs.get(n);
                if (!(itf instanceof TypeInterface) || !"collection".equals(cardinality = (typeItf = (TypeInterface)itf).getCardinality()) || !name.startsWith(n)) continue;
                return itf;
            }
            return null;
        }
        return itf;
    }
}

