/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.interfaces;

import java.util.HashSet;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;

public class InterfaceLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d);
        return d;
    }

    private void checkNode(Object node) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i]);
            }
        }
    }

    private void checkInterfaceContainer(InterfaceContainer container) throws ADLException {
        HashSet<String> names = new HashSet<String>();
        Interface[] itfs = container.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Interface itf = itfs[i];
            if (itf.getName() == null) {
                throw new ADLException("Interface name missing", (Node)((Object)itf));
            }
            if (names.contains(itf.getName())) {
                throw new ADLException("Duplicate interface name '" + itf.getName() + "'", (Node)((Object)itf));
            }
            names.add(itf.getName());
        }
    }
}

