/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.InputStream;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.Parser;
import org.objectweb.fractal.adl.ParserException;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.adl.xml.XMLParser;

public class XMLLoader
implements Loader {
    private Parser parser;

    public XMLLoader() {
        this(true);
    }

    public XMLLoader(boolean validate) {
        this.parser = new XMLParser(validate);
    }

    public Definition load(String name, Map context) throws ADLException {
        try {
            String file = name.replace('.', '/') + ".fractal";
            ClassLoader cl = ClassLoaderHelper.getClassLoader(this, context);
            InputStream is = cl.getResourceAsStream(file);
            if (is == null) {
                throw new ADLException("Cannot find '" + file + "' in the classpath", null);
            }
            Definition d = (Definition)((Object)this.parser.parse(is, file));
            if (d.getName() == null) {
                throw new ADLException("Definition name missing", (Node)((Object)d));
            }
            if (!d.getName().equals(name)) {
                throw new ADLException("Wrong definition name ('" + name + "' expected, instead of '" + d.getName() + "')", (Node)((Object)d));
            }
            return d;
        }
        catch (ParserException e) {
            throw new ADLException("Cannot load '" + name + "'", null, e);
        }
    }
}

