/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.content;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.julia.Util;

public class ChainedIllegalContentException
extends IllegalContentException {
    private final Throwable exception;
    private transient Component component;
    private transient Component content;

    public ChainedIllegalContentException(Throwable exception, Component component, Component content, String message) {
        super(message);
        this.exception = exception;
        this.component = component;
        this.content = content;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Component getComponent() {
        if (this.component != null && !(this.component instanceof Interface)) {
            try {
                return (Component)this.component.getFcInterface("component");
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
        }
        return this.component;
    }

    public Component getContent() {
        if (this.content != null && !(this.content instanceof Interface)) {
            try {
                return (Component)this.content.getFcInterface("component");
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
        }
        return this.content;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IllegalContentException: ");
        buf.append(this.getMessage());
        buf.append(" (super component = ");
        Util.toString(this.getComponent(), buf);
        if (this.getContent() != null) {
            buf.append(", sub component = ");
            Util.toString(this.getContent(), buf);
        }
        buf.append(')');
        return buf.toString();
    }

    public void printStackTrace() {
        if (this.exception != null) {
            System.err.println(this);
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.exception != null) {
            s.println(this);
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.exception != null) {
            s.write(this + "\n");
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Component c = this.getComponent();
        out.writeObject(c instanceof Interface ? c : null);
        c = this.getContent();
        out.writeObject(c instanceof Interface ? c : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.component = (Component)in.readObject();
        this.content = (Component)in.readObject();
    }
}

