/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.lewys.filtering.CacheFilter;
import org.objectweb.lewys.filtering.CacheLinearFilter;
import org.objectweb.lewys.filtering.FilterAttributes;
import org.objectweb.lewys.filtering.HybridFilter;
import org.objectweb.lewys.filtering.LinearFilter;
import org.objectweb.lewys.filtering.LinearSlideFilter;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.filtering.SlideFilter;
import org.objectweb.lewys.filtering.SwingFilter;
import org.objectweb.lewys.message.MonitoringValueChunk;
import org.objectweb.lewys.ratecontrol.RateController;
import org.objectweb.lewys.repository.MonitoringRepository;

public class FilterManager
extends AbstractComponent
implements Push,
FilterAttributes {
    private HashMap cacheFiltersMap = new HashMap();
    private HashMap linearFiltersMap = new HashMap();
    private HashMap swingFiltersMap = new HashMap();
    private HashMap slideFiltersMap1 = new HashMap();
    private HashMap slideFiltersMap2 = new HashMap();
    private HashMap hybridFiltersMap = new HashMap();
    private HashMap cacheLinearFiltersMap = new HashMap();
    private HashMap linearSlideFiltersMap = new HashMap();
    private HashMap precisionWidthMap = null;
    private MonitoringRepository repository;
    private RateController rateController = new RateController();
    private double defaultPrecisionWidth = 10.0;
    private long samplingFrequency = 1000L;
    private int MAX_OBSERVED_POINTS_PER_SIGNAL = 0;
    private int MIN_COVERED_TIME = 0;
    private Thread mainThread;
    private int insertions = 0;

    private CacheFilter getCacheFilter(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        CacheFilter filter = (CacheFilter)this.cacheFiltersMap.get(key);
        if (filter == null) {
            filter = new CacheFilter(precisionWidth);
            this.cacheFiltersMap.put(key, filter);
        }
        return filter;
    }

    private LinearFilter getLinearFilter(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        LinearFilter filter = (LinearFilter)this.linearFiltersMap.get(key);
        if (filter == null) {
            filter = new LinearFilter(precisionWidth);
            this.linearFiltersMap.put(key, filter);
        }
        return filter;
    }

    private SwingFilter getSwingFilter1(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        SwingFilter filter = (SwingFilter)this.swingFiltersMap.get(key);
        if (filter == null) {
            filter = new SwingFilter(precisionWidth);
            this.swingFiltersMap.put(key, filter);
        }
        return filter;
    }

    private SwingFilter getSwingFilter2(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        SwingFilter filter = (SwingFilter)this.swingFiltersMap.get(key);
        if (filter == null) {
            filter = new SwingFilter(precisionWidth);
            filter.setOptimizerOn(false);
            this.swingFiltersMap.put(key, filter);
        }
        return filter;
    }

    private SlideFilter getSlideFilter1(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        SlideFilter filter = (SlideFilter)this.slideFiltersMap1.get(key);
        if (filter == null) {
            filter = new SlideFilter(precisionWidth);
            this.slideFiltersMap1.put(key, filter);
        }
        return filter;
    }

    private SlideFilter getSlideFilter2(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        SlideFilter filter = (SlideFilter)this.slideFiltersMap2.get(key);
        if (filter == null) {
            filter = new SlideFilter(precisionWidth);
            filter.setOptimizerOn(false);
            this.slideFiltersMap2.put(key, filter);
        }
        return filter;
    }

    private HybridFilter getHybridFilter(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        HybridFilter filter = (HybridFilter)this.hybridFiltersMap.get(key);
        if (filter == null) {
            filter = new HybridFilter(precisionWidth);
            this.hybridFiltersMap.put(key, filter);
        }
        return filter;
    }

    private CacheLinearFilter getCacheLinearFilter(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        CacheLinearFilter filter = (CacheLinearFilter)this.cacheLinearFiltersMap.get(key);
        if (filter == null) {
            filter = new CacheLinearFilter(precisionWidth);
            this.cacheLinearFiltersMap.put(key, filter);
        }
        return filter;
    }

    private LinearSlideFilter getLinearSlideFilter(String senderName, String probeName, int resource_id, double precisionWidth) {
        String key = senderName + ";" + probeName + ";" + resource_id;
        LinearSlideFilter filter = (LinearSlideFilter)this.linearSlideFiltersMap.get(key);
        if (filter == null) {
            filter = new LinearSlideFilter(precisionWidth);
            this.linearSlideFiltersMap.put(key, filter);
        }
        return filter;
    }

    public void forwardPoint(SignalPoint point) {
    }

    public void push(Message message, Map context) throws PushException {
        CacheFilter cacheFilter = null;
        LinearFilter linearFilter = null;
        SwingFilter swingFilter1 = null;
        SwingFilter swingFilter2 = null;
        SlideFilter slideFilter1 = null;
        SlideFilter slideFilter2 = null;
        HybridFilter hybridFilter = null;
        CacheLinearFilter cacheLinearFilter = null;
        LinearSlideFilter linearSlideFilter = null;
        SignalPoint newPoint = null;
        SignalPoint[] keyPointCache = null;
        SignalPoint[] keyPointLinear = null;
        SignalPoint[] keyPointSwing1 = null;
        SignalPoint[] keyPointSwing2 = null;
        SignalPoint[] keyPointSlide1 = null;
        SignalPoint[] keyPointSlide2 = null;
        SignalPoint[] keyPointHybrid = null;
        SignalPoint[] keyPointCacheLinear = null;
        SignalPoint[] keyPointLinearSlide = null;
        try {
            MonitoringValueChunk value = (MonitoringValueChunk)message.getChunk("monitoring-value-chunk");
            String senderName = value.getSenderName();
            String probeName = value.getProbeName();
            long timestamp = value.getTimestamp();
            int[] resource_ids = value.getResourceIds();
            long[] values = value.getValues();
            int resourcesDone = 0;
            for (int i = 0; i < resource_ids.length; ++i) {
                Double precisionWidthDbl;
                String key = senderName + ";" + probeName + ";" + resource_ids[i];
                double precisionWidth = this.precisionWidthMap != null ? ((precisionWidthDbl = (Double)this.precisionWidthMap.get(key)) != null ? precisionWidthDbl : this.defaultPrecisionWidth) : this.defaultPrecisionWidth;
                cacheFilter = this.getCacheFilter(senderName, probeName, resource_ids[i], precisionWidth);
                linearFilter = this.getLinearFilter(senderName, probeName, resource_ids[i], precisionWidth);
                swingFilter1 = this.getSwingFilter1(senderName, probeName, resource_ids[i], precisionWidth);
                swingFilter2 = this.getSwingFilter2(senderName, probeName, resource_ids[i], precisionWidth);
                slideFilter1 = this.getSlideFilter1(senderName, probeName, resource_ids[i], precisionWidth);
                slideFilter2 = this.getSlideFilter2(senderName, probeName, resource_ids[i], precisionWidth);
                hybridFilter = this.getHybridFilter(senderName, probeName, resource_ids[i], precisionWidth);
                cacheLinearFilter = this.getCacheLinearFilter(senderName, probeName, resource_ids[i], precisionWidth);
                linearSlideFilter = this.getLinearSlideFilter(senderName, probeName, resource_ids[i], precisionWidth);
                if (this.MIN_COVERED_TIME > 0 && resource_ids[i] != 1 && cacheFilter.getCoveredTime() >= (long)this.MIN_COVERED_TIME && linearFilter.getCoveredTime() >= (long)this.MIN_COVERED_TIME && swingFilter1.getCoveredTime() >= (long)this.MIN_COVERED_TIME && swingFilter2.getCoveredTime() >= (long)this.MIN_COVERED_TIME && slideFilter1.getCoveredTime() >= (long)this.MIN_COVERED_TIME && slideFilter2.getCoveredTime() >= (long)this.MIN_COVERED_TIME && hybridFilter.getCoveredTime() >= (long)this.MIN_COVERED_TIME && cacheLinearFilter.getCoveredTime() >= (long)this.MIN_COVERED_TIME && linearSlideFilter.getCoveredTime() >= (long)this.MIN_COVERED_TIME) {
                    ++resourcesDone;
                    continue;
                }
                if (this.MAX_OBSERVED_POINTS_PER_SIGNAL > 0 && linearFilter.getObservedPointsCount() >= this.MAX_OBSERVED_POINTS_PER_SIGNAL) {
                    ++resourcesDone;
                    continue;
                }
                newPoint = new SignalPoint(timestamp, values[i]);
                keyPointCache = cacheFilter.getKeyPoint(newPoint);
                keyPointLinear = linearFilter.getKeyPoint(newPoint);
                keyPointSwing1 = swingFilter1.getKeyPoint(newPoint);
                keyPointSwing2 = swingFilter2.getKeyPoint(newPoint);
                keyPointSlide1 = slideFilter1.getKeyPoint(newPoint);
                keyPointSlide2 = slideFilter2.getKeyPoint(newPoint);
                keyPointHybrid = hybridFilter.getKeyPoint(newPoint);
                keyPointCacheLinear = cacheLinearFilter.getKeyPoint(newPoint);
                keyPointLinearSlide = linearSlideFilter.getKeyPoint(newPoint);
                if (keyPointCache != null) {
                    this.repository.insertMeasurement(senderName, probeName, (long)keyPointCache[0].getTime(), resource_ids[i], (long)keyPointCache[0].getValue(), precisionWidth, this.samplingFrequency, 1, 1);
                }
                if (keyPointLinear != null) {
                    this.repository.insertMeasurement(senderName, probeName, (long)keyPointLinear[0].getTime(), resource_ids[i], (long)keyPointLinear[0].getValue(), precisionWidth, this.samplingFrequency, 2, 1);
                }
                if (keyPointSwing1 != null) {
                    this.repository.insertMeasurement(senderName, probeName, (long)keyPointSwing1[0].getTime(), resource_ids[i], (long)keyPointSwing1[0].getValue(), precisionWidth, this.samplingFrequency, 3, 1);
                }
                if (keyPointSwing2 != null) {
                    this.repository.insertMeasurement(senderName, probeName, (long)keyPointSwing2[0].getTime(), resource_ids[i], (long)keyPointSwing2[0].getValue(), precisionWidth, this.samplingFrequency, 3, 1);
                }
                if (keyPointSlide1 != null) {
                    if (keyPointSlide1.length == 1) {
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide1[0].getTime(), resource_ids[i], (long)keyPointSlide1[0].getValue(), precisionWidth, this.samplingFrequency, 4, 1);
                    } else {
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide1[0].getTime(), resource_ids[i], (long)keyPointSlide1[1].getValue(), precisionWidth, this.samplingFrequency, 4, 0);
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide1[1].getTime(), resource_ids[i], (long)keyPointSlide1[1].getValue(), precisionWidth, this.samplingFrequency, 4, 1);
                    }
                }
                if (keyPointSlide2 != null) {
                    if (keyPointSlide2.length == 1) {
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide2[0].getTime(), resource_ids[i], (long)keyPointSlide2[0].getValue(), precisionWidth, this.samplingFrequency, 4, 1);
                    } else {
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide2[0].getTime(), resource_ids[i], (long)keyPointSlide2[1].getValue(), precisionWidth, this.samplingFrequency, 4, 0);
                        this.repository.insertMeasurement(senderName, probeName, (long)keyPointSlide2[1].getTime(), resource_ids[i], (long)keyPointSlide2[1].getValue(), precisionWidth, this.samplingFrequency, 4, 1);
                    }
                }
                if (keyPointHybrid == null) continue;
                this.forwardPoint(keyPointHybrid[0]);
            }
            if (resourcesDone >= resource_ids.length - 1 && this.mainThread != null) {
                this.mainThread.interrupt();
            }
        }
        catch (Exception e) {
            throw new PushException(e);
        }
    }

    public HashMap getPrecisionWidthMap() {
        return this.precisionWidthMap;
    }

    public void setPrecisionWidthMap(HashMap precisionWidthMap) {
        this.precisionWidthMap = precisionWidthMap;
    }

    public double getDefaultPrecisionWidth() {
        return this.defaultPrecisionWidth;
    }

    public void setDefaultPrecisionWidth(double defaultPrecisionWidth) {
        this.defaultPrecisionWidth = defaultPrecisionWidth;
    }

    public long getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public void setSamplingFrequency(long samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    public void setMainThread(Thread mainThread) {
        this.mainThread = mainThread;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("monitoring-repository")) {
            this.repository = (MonitoringRepository)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"monitoring-repository"};
    }
}

