/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.filtering.SlideFilter;
import org.objectweb.lewys.filtering.SwingFilter;

public class HybridFilter
extends Filter {
    private SwingFilter swingFilter;
    private SlideFilter slideFilter;
    private int usedFilter;
    private static final int BOTH = 0;
    private static final int SWING = 1;
    private static final int SLIDE = 2;

    public HybridFilter() {
        this(0.0);
    }

    public HybridFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
        this.usedFilter = 0;
        this.swingFilter = new SwingFilter(precisionWidth);
        this.slideFilter = new SlideFilter(precisionWidth / 2.0);
    }

    public SignalPoint[] getKeyPoint(SignalPoint point) {
        ++this.observedPointsCount;
        SignalPoint[] swingPoint = null;
        SignalPoint[] slidePoint = null;
        if (this.usedFilter == 0) {
            swingPoint = this.swingFilter.getKeyPoint(point);
            slidePoint = this.slideFilter.getKeyPoint(point);
        } else if (this.usedFilter == 1) {
            swingPoint = this.swingFilter.getKeyPoint(point);
            slidePoint = swingPoint;
        } else if (this.usedFilter == 2) {
            slidePoint = this.slideFilter.getKeyPoint(point);
            swingPoint = slidePoint;
        }
        if (swingPoint == null && slidePoint == null) {
            return null;
        }
        if (swingPoint == null && slidePoint != null) {
            this.usedFilter = 1;
            return null;
        }
        if (swingPoint != null && slidePoint == null) {
            this.usedFilter = 2;
            return null;
        }
        if (swingPoint != null && slidePoint != null) {
            this.usedFilter = 0;
            this.swingFilter.reset(slidePoint[0], point);
            this.slideFilter.reset(slidePoint[0], point);
            if (this.observedPointsCount == 1) {
                this.firstTime = (long)slidePoint[0].getTime();
            }
            this.lastTime = (long)slidePoint[0].getTime();
            return slidePoint;
        }
        return null;
    }
}

