/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class KernelProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 3;
    private long[] resourceValues;
    private RandomAccessFile procFile;
    private byte[] buffer;
    private static NoResourceToProbeException invalidFileFormat = new NoResourceToProbeException("Invalid /proc/stat file format for this probe.");
    private static final int BUFFER_SIZE = 2048;

    public KernelProbe() throws NoResourceToProbeException {
        super("kernel probe");
        int i;
        try {
            this.procFile = new RandomAccessFile("/proc/stat", "r");
            this.buffer = new byte[2048];
            this.procFile.read(this.buffer);
            i = 0;
            while (true) {
                if (this.buffer[i] != 10) {
                    ++i;
                    continue;
                }
                if (this.buffer[++i] == 105) break;
            }
            int n = ++i;
            ++i;
            if (this.buffer[n] != 110) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 116) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 114) {
                throw invalidFileFormat;
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                ++i;
            }
            if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                throw invalidFileFormat;
            }
            while (this.buffer[i] != 10) {
                ++i;
            }
            if (this.buffer[++i] != 99) {
                while (this.buffer[i] != 10) {
                    ++i;
                }
            }
            int n2 = ++i;
            ++i;
            if (this.buffer[n2] != 99) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 116) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 120) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 116) {
                throw invalidFileFormat;
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                ++i;
            }
            if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                throw invalidFileFormat;
            }
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            while (this.buffer[i] != 10) {
                ++i;
            }
            int n3 = ++i;
            ++i;
            if (this.buffer[n3] != 112) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 114) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 111) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 99) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 101) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 115) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 115) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 101) {
                throw invalidFileFormat;
            }
            if (this.buffer[i++] != 115) {
                throw invalidFileFormat;
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                ++i;
            }
            if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                throw invalidFileFormat;
            }
        }
        catch (Exception e) {
            try {
                this.procFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        this.resourceIds = new int[3];
        this.resourceValues = new long[3];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        this.resourceNames = new String[]{"Interrupts", "Context switches", "Processes"};
    }

    protected void finalize() throws Throwable {
        try {
            this.procFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getKernelUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 3) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    private void getKernelUsage() throws ProbeException {
        try {
            this.procFile.seek(0L);
            this.procFile.read(this.buffer);
            int i = 3;
            while (true) {
                if (this.buffer[i] != 10) {
                    ++i;
                    continue;
                }
                if (this.buffer[++i] == 105) break;
            }
            i += 4;
            while (this.buffer[i] == 32) {
                ++i;
            }
            long foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[0] = foo;
            while (this.buffer[i] != 10) {
                ++i;
            }
            if (this.buffer[++i] != 99) {
                while (this.buffer[i] != 10) {
                    ++i;
                }
                ++i;
            }
            i += 4;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[1] = foo;
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            while (this.buffer[i] != 10) {
                ++i;
            }
            i += 10;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[2] = foo;
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

