/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class Linux2_6MemoryProbe
extends AbstractProbe {
    private int NB_OF_RESSOURCES;
    private long[] resourceValues;
    private RandomAccessFile meminfoProcFile;
    private static NoResourceToProbeException invalidMeminfoFileFormat = new NoResourceToProbeException("Invalid /proc/meminfo file format for this probe.");

    public Linux2_6MemoryProbe() throws NoResourceToProbeException {
        super("memory probe");
        try {
            int i;
            String currentline;
            this.meminfoProcFile = new RandomAccessFile("/proc/meminfo", "r");
            this.meminfoProcFile.seek(0L);
            ArrayList<String> resources = new ArrayList<String>();
            while ((currentline = this.meminfoProcFile.readLine()) != null) {
                i = 0;
                StringBuffer ressourceName = new StringBuffer();
                while (currentline.charAt(i) != ':') {
                    ressourceName.append(currentline.charAt(i));
                    ++i;
                }
                ++i;
                resources.add(ressourceName.toString());
                while (currentline.charAt(i) == ' ') {
                    ++i;
                }
                while (i < currentline.length() && currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                    ++i;
                }
            }
            this.NB_OF_RESSOURCES = resources.size();
            this.resourceNames = new String[this.NB_OF_RESSOURCES];
            for (int j = 0; j < this.resourceNames.length; ++j) {
                this.resourceNames[j] = (String)resources.get(j);
            }
            this.resourceIds = new int[this.NB_OF_RESSOURCES];
            this.resourceValues = new long[this.NB_OF_RESSOURCES];
            for (i = 0; i < this.resourceIds.length; ++i) {
                this.resourceIds[i] = i;
            }
        }
        catch (Exception e) {
            try {
                this.meminfoProcFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            throw invalidMeminfoFileFormat;
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getMemoryUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= this.NB_OF_RESSOURCES) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    protected void finalize() throws Throwable {
        try {
            this.meminfoProcFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getMemoryUsage() throws ProbeException {
        try {
            this.meminfoProcFile.seek(0L);
            for (int resourceid = 0; resourceid < this.NB_OF_RESSOURCES; ++resourceid) {
                String currentline = this.meminfoProcFile.readLine();
                int i = 0;
                long foo = 0L;
                while (currentline.charAt(i) != ':') {
                    ++i;
                }
                ++i;
                while (currentline.charAt(i) == ' ') {
                    ++i;
                }
                while (i < currentline.length() && currentline.charAt(i) >= '0' && currentline.charAt(i) <= '9') {
                    foo = foo * 10L + (long)currentline.charAt(i) - 48L;
                    ++i;
                }
                this.resourceValues[resourceid] = foo;
            }
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

