/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.macosx;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class DiskProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESOURCES = 13;
    private static final int READS_ISSUED_RES = 0;
    private static final int READS_MERGED_RES = 1;
    private static final int READ_SECTOR_RES = 2;
    private static final int READ_TIME_IN_MS_RES = 3;
    private static final int WRITES_ISSUED_RES = 4;
    private static final int WRITES_MERGED_RES = 5;
    private static final int WRITE_SECTORS_RES = 6;
    private static final int WRITE_TIME_IN_MS_RES = 7;
    private static final int IO_IN_PROGRESS_RES = 8;
    private static final int IO_IN_MS_RES = 9;
    private static final int AVERAGE_IO_MS_RES = 10;
    private static final int BYTES_READ_RES = 11;
    private static final int BYTES_WRITTEN_RES = 12;
    private long[] readsIssued;
    private long[] readsMerged;
    private long[] readSectors;
    private long[] readTimeInMs;
    private long[] writesIssued;
    private long[] writesMerged;
    private long[] writeSectors;
    private long[] writeTimeInMs;
    private long[] ioInProgress;
    private long[] ioInMs;
    private long[] averageIoMs;
    private long[] bytesRead;
    private long[] bytesWritten;
    private int nbOfDisks = 0;

    public DiskProbe() throws NoResourceToProbeException {
        super("disk probe");
        String[] names = this.getDiskNames();
        this.nbOfDisks = names.length;
        this.readsIssued = new long[this.nbOfDisks];
        this.readsMerged = new long[this.nbOfDisks];
        this.readSectors = new long[this.nbOfDisks];
        this.readTimeInMs = new long[this.nbOfDisks];
        this.writesIssued = new long[this.nbOfDisks];
        this.writesMerged = new long[this.nbOfDisks];
        this.writeSectors = new long[this.nbOfDisks];
        this.writeTimeInMs = new long[this.nbOfDisks];
        this.ioInProgress = new long[this.nbOfDisks];
        this.ioInMs = new long[this.nbOfDisks];
        this.averageIoMs = new long[this.nbOfDisks];
        this.bytesRead = new long[this.nbOfDisks];
        this.bytesWritten = new long[this.nbOfDisks];
        this.resourceNames = new String[this.nbOfDisks * 13];
        this.resourceIds = new int[this.resourceNames.length];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (int j = 0; j < this.nbOfDisks; ++j) {
            this.resourceNames[j * 13 + 0] = names[j] + " reads issued";
            this.resourceNames[j * 13 + 1] = names[j] + " reads merged";
            this.resourceNames[j * 13 + 2] = names[j] + " read sectors";
            this.resourceNames[j * 13 + 3] = names[j] + " read time in ms";
            this.resourceNames[j * 13 + 4] = names[j] + " writes issued";
            this.resourceNames[j * 13 + 5] = names[j] + " writes merged";
            this.resourceNames[j * 13 + 6] = names[j] + " write sectors";
            this.resourceNames[j * 13 + 7] = names[j] + " write time in ms";
            this.resourceNames[j * 13 + 8] = names[j] + " io in progress";
            this.resourceNames[j * 13 + 9] = names[j] + " io in ms";
            this.resourceNames[j * 13 + 10] = names[j] + " average io in ms";
            this.resourceNames[j * 13 + 11] = names[j] + " bytes read";
            this.resourceNames[j * 13 + 12] = names[j] + " bytes written";
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getDiskUsage();
        long[] result = new long[resourceIds.length];
        block15: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 13 * this.nbOfDisks) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int disk = resourceIds[i] / 13;
            switch (resourceIds[i] % 13) {
                case 0: {
                    result[i] = this.readsIssued[disk];
                    continue block15;
                }
                case 1: {
                    result[i] = this.readsMerged[disk];
                    continue block15;
                }
                case 2: {
                    result[i] = this.readSectors[disk];
                    continue block15;
                }
                case 3: {
                    result[i] = this.readTimeInMs[disk];
                    continue block15;
                }
                case 4: {
                    result[i] = this.writesIssued[disk];
                    continue block15;
                }
                case 5: {
                    result[i] = this.writesMerged[disk];
                    continue block15;
                }
                case 6: {
                    result[i] = this.writeSectors[disk];
                    continue block15;
                }
                case 7: {
                    result[i] = this.writeTimeInMs[disk];
                    continue block15;
                }
                case 8: {
                    result[i] = this.ioInProgress[disk];
                    continue block15;
                }
                case 9: {
                    result[i] = this.ioInMs[disk];
                    continue block15;
                }
                case 10: {
                    result[i] = this.averageIoMs[disk];
                    continue block15;
                }
                case 11: {
                    result[i] = this.bytesRead[disk];
                    continue block15;
                }
                case 12: {
                    result[i] = this.bytesWritten[disk];
                    continue block15;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getDiskUsage() throws ProbeException {
        long[] stats = this.getDiskStats();
        if (stats.length != this.nbOfDisks * 13) {
            throw new ProbeException("Internal error!");
        }
        for (int disk = 0; disk < this.nbOfDisks; ++disk) {
            this.readsIssued[disk] = stats[disk * 13 + 0];
            this.readsMerged[disk] = stats[disk * 13 + 1];
            this.readSectors[disk] = stats[disk * 13 + 2];
            this.readTimeInMs[disk] = stats[disk * 13 + 3];
            this.writesIssued[disk] = stats[disk * 13 + 4];
            this.writesMerged[disk] = stats[disk * 13 + 5];
            this.writeSectors[disk] = stats[disk * 13 + 6];
            this.writeTimeInMs[disk] = stats[disk * 13 + 7];
            this.ioInProgress[disk] = stats[disk * 13 + 8];
            this.ioInMs[disk] = stats[disk * 13 + 9];
            this.averageIoMs[disk] = stats[disk * 13 + 10];
            this.bytesRead[disk] = stats[disk * 13 + 11];
            this.bytesWritten[disk] = stats[disk * 13 + 12];
        }
    }

    public native String[] getDiskNames() throws NoResourceToProbeException;

    public native long[] getDiskStats() throws ProbeException;

    static {
        System.loadLibrary("LeWYS");
    }
}

