/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class NetworkProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 16;
    private long[] bytesReceived;
    private long[] packetsReceived;
    private long[] errorsReceived;
    private long[] dropReceived;
    private long[] fifoReceived;
    private long[] frameReceived;
    private long[] compressedReceived;
    private long[] multicastReceived;
    private long[] bytesTransmit;
    private long[] packetsTransmit;
    private long[] errorsTransmit;
    private long[] dropTransmit;
    private long[] fifoTransmit;
    private long[] collisionsTransmit;
    private long[] carrierTransmit;
    private long[] compressedTransmit;
    private int nbOfDevices = 0;
    private String[] netInterfaceNames = this.getNetworkInterfaces();

    public NetworkProbe() throws NoResourceToProbeException {
        super("network probe");
        this.nbOfDevices = this.netInterfaceNames.length;
        this.bytesReceived = new long[this.nbOfDevices];
        this.packetsReceived = new long[this.nbOfDevices];
        this.errorsReceived = new long[this.nbOfDevices];
        this.dropReceived = new long[this.nbOfDevices];
        this.fifoReceived = new long[this.nbOfDevices];
        this.frameReceived = new long[this.nbOfDevices];
        this.compressedReceived = new long[this.nbOfDevices];
        this.multicastReceived = new long[this.nbOfDevices];
        this.bytesTransmit = new long[this.nbOfDevices];
        this.packetsTransmit = new long[this.nbOfDevices];
        this.errorsTransmit = new long[this.nbOfDevices];
        this.dropTransmit = new long[this.nbOfDevices];
        this.fifoTransmit = new long[this.nbOfDevices];
        this.collisionsTransmit = new long[this.nbOfDevices];
        this.carrierTransmit = new long[this.nbOfDevices];
        this.compressedTransmit = new long[this.nbOfDevices];
        this.resourceNames = new String[this.nbOfDevices * 16];
        this.resourceIds = new int[this.resourceNames.length];
        for (int i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (int j = 0; j < this.nbOfDevices; ++j) {
            this.resourceNames[j * 16] = this.netInterfaceNames[j] + " bytes received";
            this.resourceNames[j * 16 + 1] = this.netInterfaceNames[j] + " packets received";
            this.resourceNames[j * 16 + 2] = this.netInterfaceNames[j] + " errors received";
            this.resourceNames[j * 16 + 3] = this.netInterfaceNames[j] + " drop received";
            this.resourceNames[j * 16 + 4] = this.netInterfaceNames[j] + " fifo received";
            this.resourceNames[j * 16 + 5] = this.netInterfaceNames[j] + " frame received";
            this.resourceNames[j * 16 + 6] = this.netInterfaceNames[j] + " compressed received";
            this.resourceNames[j * 16 + 7] = this.netInterfaceNames[j] + " multicast";
            this.resourceNames[j * 16 + 8] = this.netInterfaceNames[j] + " bytes transmit";
            this.resourceNames[j * 16 + 9] = this.netInterfaceNames[j] + " packets transmit";
            this.resourceNames[j * 16 + 10] = this.netInterfaceNames[j] + " errors transmit";
            this.resourceNames[j * 16 + 11] = this.netInterfaceNames[j] + " drop transmit";
            this.resourceNames[j * 16 + 12] = this.netInterfaceNames[j] + " fifo transmit";
            this.resourceNames[j * 16 + 13] = this.netInterfaceNames[j] + " collisions";
            this.resourceNames[j * 16 + 14] = this.netInterfaceNames[j] + " carrier";
            this.resourceNames[j * 16 + 15] = this.netInterfaceNames[j] + " compressed transmit";
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getNetworkUsage();
        long[] result = new long[resourceIds.length];
        block18: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 16 * this.nbOfDevices) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int net = resourceIds[i] / 16;
            switch (resourceIds[i] % 16) {
                case 0: {
                    result[i] = this.bytesReceived[net];
                    continue block18;
                }
                case 1: {
                    result[i] = this.packetsReceived[net];
                    continue block18;
                }
                case 2: {
                    result[i] = this.errorsReceived[net];
                    continue block18;
                }
                case 3: {
                    result[i] = this.dropReceived[net];
                    continue block18;
                }
                case 4: {
                    result[i] = this.fifoReceived[net];
                    continue block18;
                }
                case 5: {
                    result[i] = this.frameReceived[net];
                    continue block18;
                }
                case 6: {
                    result[i] = this.compressedReceived[net];
                    continue block18;
                }
                case 7: {
                    result[i] = this.multicastReceived[net];
                    continue block18;
                }
                case 8: {
                    result[i] = this.bytesTransmit[net];
                    continue block18;
                }
                case 9: {
                    result[i] = this.packetsTransmit[net];
                    continue block18;
                }
                case 10: {
                    result[i] = this.errorsTransmit[net];
                    continue block18;
                }
                case 11: {
                    result[i] = this.dropTransmit[net];
                    continue block18;
                }
                case 12: {
                    result[i] = this.fifoTransmit[net];
                    continue block18;
                }
                case 13: {
                    result[i] = this.collisionsTransmit[net];
                    continue block18;
                }
                case 14: {
                    result[i] = this.carrierTransmit[net];
                    continue block18;
                }
                case 15: {
                    result[i] = this.compressedTransmit[net];
                    continue block18;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getNetworkUsage() throws ProbeException {
        for (int i = 0; i < this.nbOfDevices; ++i) {
            long[] values = this.getNetworkState(this.netInterfaceNames[i]);
            this.bytesReceived[i] = values[0];
            this.packetsReceived[i] = values[1];
            this.errorsReceived[i] = values[2];
            this.dropReceived[i] = values[3];
            this.fifoReceived[i] = values[4];
            this.frameReceived[i] = values[5];
            this.compressedReceived[i] = values[6];
            this.multicastReceived[i] = values[7];
            this.bytesTransmit[i] = values[8];
            this.packetsTransmit[i] = values[9];
            this.errorsTransmit[i] = values[10];
            this.dropTransmit[i] = values[11];
            this.fifoTransmit[i] = values[12];
            this.collisionsTransmit[i] = values[13];
            this.carrierTransmit[i] = values[14];
            this.compressedTransmit[i] = values[15];
        }
    }

    public native String[] getNetworkInterfaces();

    public native long[] getNetworkState(String var1);

    public native int getRTT(String var1, int var2);

    static {
        System.loadLibrary("LeWYS");
    }
}

