/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.sql.DataSource;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.util.EmptyStringArray;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.lewys.common.exceptions.RepositoryException;
import org.objectweb.lewys.message.MonitoringValueChunk;
import org.objectweb.lewys.repository.MonitoringRepository;
import org.objectweb.lewys.repository.requestplayer.ClientEmulator;

public class MonitoringRepositoryImpl
extends AbstractComponent
implements MonitoringRepository,
Push {
    protected Context initialContext = null;
    protected DataSource dataSource = null;
    protected Connection conn = null;
    protected ClientEmulator client = new ClientEmulator(null);
    protected HashMap resourcesMap = null;

    public MonitoringRepositoryImpl() throws RemoteException {
        this.conn = this.client.getConnection();
        try {
            this.loadResourcesMap();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private void loadResourcesMap() throws RepositoryException {
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        this.resourcesMap = new HashMap();
        try {
            selectStmt = this.conn.prepareStatement("SELECT n.name as nodeName, pb.name as probeName, pr.resource_id, pr.id FROM nodes n,pumps pu,probes pb,probe_resources pr WHERE n.id = pu.node AND pu.id = pb.pump AND pb.id = pr.probe");
            rs = selectStmt.executeQuery();
            while (rs.next()) {
                String nodeName = rs.getString("nodeName");
                String probeName = rs.getString("probeName");
                int resource_id = rs.getInt("resource_id");
                Integer id = new Integer(rs.getInt("id"));
                String key = nodeName + ";" + probeName + ";" + resource_id;
                this.resourcesMap.put(key, id);
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error when accessing database at repository initialization: " + e);
        }
    }

    private void insertMeasurements(Message message, Map context) throws RepositoryException {
        MonitoringValueChunk value = (MonitoringValueChunk)message.getChunk("monitoring-value-chunk");
        String senderName = value.getSenderName();
        String probeName = value.getProbeName();
        long timestamp = value.getTimestamp();
        int[] resource_ids = value.getResourceIds();
        long[] values = value.getValues();
        for (int i = 0; i < resource_ids.length; ++i) {
            String key = senderName + ";" + probeName + ";" + resource_ids[i];
            int id = (Integer)this.resourcesMap.get(key);
            String sql = "date vdbName W 0 INSERT INTO measurements (probe_resource,value,timestmp) values(" + id + "," + values[i] + ",'" + timestamp + "')";
            this.client.addRequest(sql);
        }
    }

    private void registerProbes(Message message, Map context) throws RepositoryException {
        MonitoringValueChunk value = (MonitoringValueChunk)message.getChunk("monitoring-value-chunk");
        String senderName = value.getSenderName();
        String probeName = value.getProbeName();
        String probeType = "some_type";
        int[] resource_ids = value.getResourceIds();
        String[] resourceNames = new String[]{"name1", "name2", "..etc"};
        String[] resourceTypes = new String[]{"type1", "type2", "..etc"};
        String[] probedNodeNames = new String[]{"name1", "name2", "..etc"};
        ResultSet rs = null;
        PreparedStatement selectStmt = null;
        Statement insertStmt = null;
        try {
            int probeId;
            selectStmt = this.conn.prepareStatement("SELECT pb.id FROM nodes n, pumps pu, probes pb WHERE n.id = pu.node AND pu.id = pb.pump AND n.name=? AND pb.name=?");
            selectStmt.setString(1, senderName);
            selectStmt.setString(2, probeName);
            rs = selectStmt.executeQuery();
            if (rs.next()) {
                probeId = rs.getInt("id");
            } else {
                selectStmt.close();
                selectStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT pu.id FROM nodes n,pumps pu WHERE n.id = pu.node AND n.name=?");
                selectStmt.setString(1, senderName);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    throw new RepositoryException("Node (" + senderName + ") and/or its pump are not registered in the monitoring repository.");
                }
                int pumpId = rs.getInt("id");
                selectStmt.close();
                selectStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT pt.id FROM probe_types pt WHERE pt.name=?");
                selectStmt.setString(1, probeType);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    throw new RepositoryException("ProbeType (" + probeType + ") is not registered in the monitoring repository.");
                }
                int probeTypeId = rs.getInt("id");
                selectStmt.close();
                selectStmt = null;
                insertStmt = this.conn.prepareStatement("INSERT INTO probes (name,pump,probe_type) values(?,?,?)");
                insertStmt.setString(1, probeName);
                insertStmt.setInt(2, pumpId);
                insertStmt.setInt(3, probeTypeId);
                insertStmt.executeUpdate();
                insertStmt.close();
                insertStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT pb.id FROM probes pb WHERE pb.name=? AND pb.pump=?");
                selectStmt.setString(1, probeName);
                selectStmt.setInt(2, pumpId);
                rs = selectStmt.executeQuery();
                probeId = rs.getInt("id");
                selectStmt.close();
                selectStmt = null;
            }
            for (int i = 0; i < resource_ids.length; ++i) {
                selectStmt = this.conn.prepareStatement("SELECT rt.id FROM resource_types rt WHERE rt.name=?");
                selectStmt.setString(1, resourceTypes[i]);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    throw new RepositoryException("ResourceType (" + resourceTypes[i] + ") is not registered in the monitoring repository.");
                }
                int resourceTypeId = rs.getInt("id");
                selectStmt.close();
                selectStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT n.id FROM nodes n WHERE n.name=?");
                selectStmt.setString(1, probedNodeNames[i]);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    throw new RepositoryException("Node (" + probedNodeNames[i] + ") is not registered in the monitoring repository.");
                }
                int nodeId = rs.getInt("id");
                selectStmt.close();
                selectStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT pr.id FROM probe_resources pr WHERE pr.probe=? AND pr.resource_type=? AND pr.probed_node=?");
                selectStmt.setInt(1, probeId);
                selectStmt.setInt(1, resourceTypeId);
                selectStmt.setInt(1, nodeId);
                rs = selectStmt.executeQuery();
                if (rs.next()) {
                    selectStmt.close();
                    selectStmt = null;
                    continue;
                }
                selectStmt.close();
                selectStmt = null;
                insertStmt = this.conn.prepareStatement("INSERT INTO probe_resource (probe,resource_type,resource_id,probed_node) values(?,?,?,?)");
                insertStmt.setInt(1, probeId);
                insertStmt.setInt(2, resourceTypeId);
                insertStmt.setInt(3, resource_ids[i]);
                insertStmt.setInt(4, nodeId);
                insertStmt.executeUpdate();
                insertStmt.close();
                insertStmt = null;
                selectStmt = this.conn.prepareStatement("SELECT pr.id FROM probe_resources pr WHERE pr.probe=? AND pr.resource_type=? AND pr.probed_node=?");
                selectStmt.setInt(1, probeId);
                selectStmt.setInt(2, resourceTypeId);
                selectStmt.setInt(2, nodeId);
                rs = selectStmt.executeQuery();
                Integer resourceId = new Integer(rs.getInt("id"));
                selectStmt.close();
                selectStmt = null;
                String key = senderName + ";" + probeName + ";" + resource_ids[i];
                this.resourcesMap.put(key, resourceId);
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (insertStmt != null) {
                insertStmt.close();
            }
        }
        catch (SQLException e) {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (insertStmt != null) {
                    insertStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public ClientEmulator getClient() {
        return this.client;
    }

    public void insertMeasurement(String senderName, String probeName, long timestamp, int resource_id, long value, double precision_width, long samplingFrequency, int approxMethod, int newLine) throws RepositoryException {
        String key = senderName + ";" + probeName + ";" + resource_id;
        int id = (Integer)this.resourcesMap.get(key);
        String sql = "date vdbName W 0 INSERT INTO measurements (probe_resource,value,timestmp,precision_width,sampling_freq,filter_type,new_line) values(" + id + "," + value + ",'" + timestamp + "'," + precision_width + "," + samplingFrequency + "," + approxMethod + "," + newLine + ")";
        this.client.addRequest(sql);
    }

    public Connection getConnection() {
        return this.client.getConnection();
    }

    public void flushRequests() {
        this.client.flushRequests();
    }

    public void shutDown() {
        this.client.shutDown();
    }

    public void push(Message message, Map context) throws PushException {
        try {
            MonitoringValueChunk value = (MonitoringValueChunk)message.getChunk("monitoring-value-chunk");
            String messageType = "data";
            if (messageType == "command") {
                this.registerProbes(message, context);
            } else if (messageType == "data") {
                this.insertMeasurements(message, context);
            }
        }
        catch (Exception e) {
            throw new PushException(e);
        }
    }

    public String[] listFc() {
        return EmptyStringArray.EMPTY_STRING_ARRAY;
    }

    public void startFc() throws IllegalLifeCycleException {
        super.startFc();
    }

    public void stopFc() throws IllegalLifeCycleException {
        super.stopFc();
        this.client.shutDown();
    }
}

