/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.requestplayer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.objectweb.cjdbc.common.util.Stats;
import org.objectweb.lewys.repository.requestplayer.ClientThread;
import org.objectweb.lewys.repository.requestplayer.MonitoringThread;
import org.objectweb.lewys.repository.requestplayer.RequestPlayerProperties;

public class ClientEmulator {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    private static final Integer ZERO = new Integer(0);
    private File configFile;
    private String propUrl;
    private String propUsername;
    private String propPassword;
    private RequestPlayerProperties requestPlayerProp = null;
    protected BufferedReader sqlTrace = null;
    protected Stats selectStats = new Stats("Select");
    protected Stats unknownStats = new Stats("Unknown");
    protected Stats updateStats = new Stats("Update");
    protected Stats insertStats = new Stats("Insert");
    protected Stats deleteStats = new Stats("Delete");
    protected Stats beginStats = new Stats("Begin");
    protected Stats commitStats = new Stats("Commit");
    protected Stats rollbackStats = new Stats("Rollback");
    protected Stats getConnectionStats = new Stats("Get connection from driver");
    protected Stats closeStats = new Stats("Close connection");
    protected Stats getRequestStats = new Stats("Get requests from log file");
    private int nbRequests = 0;
    private int maxRequests = 0;
    private Hashtable tidList = new Hashtable();
    private HashSet ignoredTids = new HashSet();
    private int timeout;
    private int connectionType;
    private Stack freeConnections = null;
    private int poolSize;
    private Integer transactionId;
    private int nbClients;
    private ClientThread[] threads;
    private MonitoringThread monitor;

    public ClientEmulator(String configFile) {
        int nbTables;
        this.requestPlayerProp = new RequestPlayerProperties(configFile);
        if (!this.requestPlayerProp.checkPropertiesFile()) {
            Runtime.getRuntime().exit(1);
        }
        this.propUrl = this.requestPlayerProp.getDatabaseURL();
        this.propUsername = this.requestPlayerProp.getDatabaseUsername();
        this.propPassword = this.requestPlayerProp.getDatabasePassword();
        try {
            Class.forName(this.requestPlayerProp.getDatabaseDriver());
        }
        catch (Exception e) {
            System.out.println("Unable to load database driver '" + this.requestPlayerProp.getDatabaseDriver() + "' (" + e + ")");
            Runtime.getRuntime().exit(1);
        }
        this.connectionType = this.requestPlayerProp.getConnectionType();
        if (this.connectionType == 2) {
            this.poolSize = this.requestPlayerProp.getPoolSize();
            if (this.poolSize <= 0) {
                System.out.println("Connections pool size must be greater than 0.");
                Runtime.getRuntime().exit(1);
            }
            try {
                this.freeConnections = new Stack();
                this.initializeConnections();
            }
            catch (SQLException e) {
                System.out.println("Failed to initialize the connection pool.");
            }
        }
        this.nbClients = this.requestPlayerProp.getNbClients();
        if (this.nbClients <= 0) {
            System.out.println("Number of clients must be greater than 0.");
            Runtime.getRuntime().exit(1);
        }
        if ((nbTables = this.requestPlayerProp.getNbTables()) <= 0) {
            System.out.println("Number of table must be greater than 0.");
            Runtime.getRuntime().exit(1);
        }
        this.timeout = this.requestPlayerProp.getTimeout();
        this.maxRequests = this.requestPlayerProp.getNbRequests();
        int updateType = this.requestPlayerProp.getUpdateType();
        long timeInMS = this.requestPlayerProp.getTimeInMS();
        int batchSize = this.requestPlayerProp.getBatchSize();
        System.out.println("Creating " + this.nbClients + " threads.");
        this.threads = new ClientThread[this.nbClients];
        for (int i = 0; i < this.nbClients; ++i) {
            this.threads[i] = new ClientThread(i, this, this.connectionType, updateType, timeInMS, i % nbTables + 1, batchSize);
        }
        this.monitor = new MonitoringThread(this, 10000L);
        this.monitor.start();
        System.out.println("Starting threads.");
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.nbClients; ++i) {
            this.threads[i].start();
        }
        System.out.println("Done.");
    }

    public Connection getConnection() {
        try {
            return DriverManager.getConnection(this.propUrl, this.propUsername, this.propPassword);
        }
        catch (Exception e) {
            System.out.println("Unable to connect to database '" + this.requestPlayerProp.getDatabaseURL() + "' (" + e + ")");
            return null;
        }
    }

    public synchronized void initializeConnections() throws SQLException {
        for (int i = 0; i < this.poolSize; ++i) {
            this.freeConnections.push(this.getConnection());
        }
    }

    public void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to close the connection (" + e + ")");
        }
    }

    public synchronized Connection getConnectionFromPool() {
        try {
            while (this.freeConnections.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.out.println("Connection pool wait interrupted.");
                }
            }
            Connection c = (Connection)this.freeConnections.pop();
            return c;
        }
        catch (EmptyStackException e) {
            System.out.println("Out of connections.");
            return null;
        }
    }

    public synchronized void releaseConnectionToPool(Connection connection) {
        boolean mustNotify = this.freeConnections.isEmpty();
        this.freeConnections.push(connection);
        if (mustNotify) {
            this.notify();
        }
    }

    public synchronized void finalizeConnections() throws SQLException {
        Connection c = null;
        while (!this.freeConnections.isEmpty()) {
            c = (Connection)this.freeConnections.pop();
            c.close();
        }
    }

    public synchronized String parallelGetNextSQLRequest(int tid) {
        ArrayList req = (ArrayList)this.tidList.get(new Integer(tid));
        if (req != null) {
            String request = (String)req.remove(0);
            if (req.isEmpty()) {
                this.tidList.remove(new Integer(tid));
            }
            ++this.nbRequests;
            return request;
        }
        if (req != null) {
            // empty if block
        }
        return null;
    }

    public void ignoreTid(int tid) {
        this.ignoredTids.add(new Integer(tid));
    }

    public synchronized String sequentialGetNextSQLRequest(int tid) {
        String request;
        do {
            if ((request = this.readRequest()) != null) continue;
            this.notifyAll();
            return null;
        } while (this.ignoredTids.contains(this.transactionId));
        if (this.transactionId == tid) {
            return request;
        }
        this.notifyAll();
        while (request != null) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.err.println("sequentialGetNextSQLRequest wait interrupted");
            }
            if (this.transactionId == null || this.transactionId == tid) continue;
            String myRequest = request;
            request = this.readRequest();
            this.notifyAll();
            return myRequest;
        }
        this.notifyAll();
        return null;
    }

    public synchronized void addRequest(String request) {
        String sql;
        StringTokenizer requestTokenizer = new StringTokenizer(request, " ");
        String date = requestTokenizer.nextToken().trim();
        String virtualDatabase = requestTokenizer.nextToken().trim();
        String type = requestTokenizer.nextToken().trim();
        this.transactionId = new Integer(requestTokenizer.nextToken().trim());
        switch (type.charAt(0)) {
            case 'B': {
                sql = "B " + this.transactionId;
                this.transactionId = ZERO;
                break;
            }
            case 'C': 
            case 'R': {
                sql = type;
                break;
            }
            default: {
                sql = type + " " + request.substring(request.indexOf(" " + this.transactionId.toString() + " ") + this.transactionId.toString().length() + 1).trim();
            }
        }
        ArrayList<String> requests = (ArrayList<String>)this.tidList.get(this.transactionId);
        if (requests == null) {
            requests = new ArrayList<String>();
            this.tidList.put(this.transactionId, requests);
        }
        requests.add(sql);
    }

    private String readRequest() {
        String request = null;
        this.transactionId = null;
        try {
            if ((this.nbRequests <= this.maxRequests || this.maxRequests == 0) && (request = this.sqlTrace.readLine()) != null) {
                String sql;
                ++this.nbRequests;
                StringTokenizer requestTokenizer = new StringTokenizer(request, " ");
                String date = requestTokenizer.nextToken().trim();
                String virtualDatabase = requestTokenizer.nextToken().trim();
                String type = requestTokenizer.nextToken().trim();
                this.transactionId = new Integer(requestTokenizer.nextToken().trim());
                switch (type.charAt(0)) {
                    case 'B': {
                        sql = "B " + this.transactionId;
                        this.transactionId = ZERO;
                        break;
                    }
                    case 'C': 
                    case 'R': {
                        sql = type;
                        break;
                    }
                    default: {
                        sql = type + " " + request.substring(request.indexOf(" " + this.transactionId.toString() + " ") + this.transactionId.toString().length() + 1).trim();
                    }
                }
                return sql.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRequests() {
        while (true) {
            Hashtable hashtable = this.tidList;
            synchronized (hashtable) {
                if (this.tidList.isEmpty()) {
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void shutDown() {
        try {
            for (int i = 0; i < this.nbClients; ++i) {
                this.threads[i].setKilled(true);
                this.threads[i].interrupt();
                this.threads[i].join();
            }
            this.monitor.setKilled(true);
            this.monitor.interrupt();
            this.monitor.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.connectionType == 2) {
            try {
                this.finalizeConnections();
            }
            catch (SQLException e) {
                System.out.println("Failed to release connections from the pool.");
            }
        }
        System.out.println("Done\n");
    }

    public Stats getDeleteStats() {
        return this.deleteStats;
    }

    public Stats getInsertStats() {
        return this.insertStats;
    }

    public Stats getSelectStats() {
        return this.selectStats;
    }

    public Stats getUnknownStats() {
        return this.unknownStats;
    }

    public Stats getUpdateStats() {
        return this.updateStats;
    }

    public Stats getBeginStats() {
        return this.beginStats;
    }

    public Stats getCloseStats() {
        return this.closeStats;
    }

    public Stats getCommitStats() {
        return this.commitStats;
    }

    public Stack getFreeConnections() {
        return this.freeConnections;
    }

    public Stats getGetConnectionStats() {
        return this.getConnectionStats;
    }

    public Stats getGetRequestStats() {
        return this.getRequestStats;
    }

    public Stats getRollbackStats() {
        return this.rollbackStats;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RequestPlayerProperties getRequestPlayerProp() {
        return this.requestPlayerProp;
    }
}

