/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.util;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.objectweb.lewys.common.exceptions.RepositoryException;
import org.objectweb.lewys.repository.MonitoringRepositoryImpl;

public class DeltasCalculator {
    private MonitoringRepositoryImpl repository = new MonitoringRepositoryImpl();
    private Connection conn = this.repository.getConnection();

    public void calculateDeltas() throws RepositoryException {
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        PreparedStatement selectStmt1 = null;
        Statement selectStmt2 = null;
        Statement insertStmt = null;
        Statement updateStmt = null;
        try {
            selectStmt1 = this.conn.prepareStatement("SELECT distinct probe_resource FROM measurements1");
            rs1 = selectStmt1.executeQuery();
            while (rs1.next()) {
                int probe_resource = rs1.getInt("probe_resource");
                long oldTimestamp = -1L;
                double oldValue = -1.0;
                selectStmt2 = this.conn.prepareStatement("SELECT value,timestmp FROM measurements1 WHERE filter_type=0 AND probe_resource=? ORDER BY timestmp");
                selectStmt2.setInt(1, probe_resource);
                rs2 = selectStmt2.executeQuery();
                while (rs2.next()) {
                    double value = rs2.getDouble("value");
                    long timestamp = rs2.getLong("timestmp");
                    if (oldTimestamp < 0L) {
                        oldTimestamp = timestamp;
                        oldValue = value;
                        continue;
                    }
                    if (timestamp == oldTimestamp) continue;
                    long deltaTime = timestamp - oldTimestamp;
                    double deltaValue = value - oldValue;
                    oldTimestamp = timestamp;
                    oldValue = value;
                    insertStmt = this.conn.prepareStatement("INSERT INTO deltas (probe_resource,timestmp,delta) values(?,?,?)");
                    insertStmt.setInt(1, probe_resource);
                    insertStmt.setLong(2, timestamp);
                    insertStmt.setDouble(3, deltaValue);
                    insertStmt.executeUpdate();
                    insertStmt.close();
                    insertStmt = null;
                }
                selectStmt2.close();
                selectStmt2 = null;
            }
            selectStmt1.close();
            selectStmt1 = null;
            selectStmt1 = this.conn.prepareStatement("SELECT distinct rt.name FROM measurements1 m, probe_resources pr, resource_types rt WHERE m.probe_resource=pr.id AND pr.resource_type=rt.id");
            rs1 = selectStmt1.executeQuery();
            while (rs1.next()) {
                String name = rs1.getString("name");
                selectStmt2 = this.conn.prepareStatement("SELECT min(d.delta) as mn, max(d.delta) as mx FROM deltas d, probe_resources pr, resource_types rt WHERE d.probe_resource=pr.id AND pr.resource_type=rt.id AND rt.name=?");
                selectStmt2.setString(1, name);
                rs2 = selectStmt2.executeQuery();
                rs2.next();
                double minDelta = rs2.getDouble("mn");
                double maxDelta = rs2.getDouble("mx");
                selectStmt2.close();
                selectStmt2 = null;
                selectStmt2 = this.conn.prepareStatement("SELECT min(m.value) as mn, max(m.value) as mx FROM measurements1 m, probe_resources pr, resource_types rt WHERE m.probe_resource=pr.id AND pr.resource_type=rt.id AND rt.name=?");
                selectStmt2.setString(1, name);
                rs2 = selectStmt2.executeQuery();
                rs2.next();
                double min = rs2.getDouble("mn");
                double max = rs2.getDouble("mx");
                selectStmt2.close();
                selectStmt2 = null;
                insertStmt = this.conn.prepareStatement("INSERT INTO ranges (resource_type,range,delta_range) values(?,?,?)");
                insertStmt.setString(1, name);
                insertStmt.setDouble(2, max - min);
                insertStmt.setDouble(2, maxDelta - minDelta);
            }
            selectStmt1.close();
            selectStmt1 = null;
            this.repository.getClient().shutDown();
        }
        catch (SQLException e) {
            try {
                if (selectStmt1 != null) {
                    selectStmt1.close();
                }
                if (selectStmt2 != null) {
                    selectStmt2.close();
                }
                if (insertStmt != null) {
                    insertStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new RepositoryException("Error while accessing database: " + e);
        }
    }

    public static void main(String[] args) {
        try {
            DeltasCalculator calculator = new DeltasCalculator();
            calculator.calculateDeltas();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

