/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.util;

import java.io.FileWriter;
import java.io.IOException;

public class PopulatorScriptGenerator {
    public static final String SCRIPT_FILE_NAME = "populate_lewys1.sql";
    public static final int NUMBER_OF_NODES = 50;
    public static final int NUMBER_OF_PROBE_CLASSES = 3;
    public static final int NUMBER_OF_PROBE_TYPES = 6;
    public static final int NUMBER_OF_RESOURCE_TYPES = 82;
    private FileWriter scriptFile;
    private String[] nodes;
    private String[] nodeIPs;
    private String[] probeClasses;
    private int[] probeTypesCountPerProbeClass;
    private String[] probeTypes;
    private int[] resourceTypesCountPerProbeType;
    private String[] resourceTypes;
    private String[] probes;

    public PopulatorScriptGenerator() {
        try {
            this.nodes = new String[50];
            this.nodeIPs = new String[50];
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i] = "sci" + i;
                this.nodeIPs[i] = "192.168.20." + i;
            }
            this.nodes[0] = "sci0.cluster";
            this.nodes[7] = "sci7.cluster";
            this.nodeIPs[0] = "192.168.20.200";
            this.probeClasses = new String[]{"hardware", "operating system", "jmx"};
            this.probeTypesCountPerProbeClass = new int[]{4, 1, 1};
            this.probeTypes = new String[]{"cpu", "disk", "memory", "network", "kernel", "cjdbc"};
            this.resourceTypesCountPerProbeType = new int[]{20, 132, 13, 80, 3, 31};
            this.probes = new String[]{"cpu probe", "disk probe", "memory probe", "network probe", "kernel probe", "cjdbc probe"};
            this.resourceTypes = new String[]{"cpu user", "cpu nice", "cpu kernel", "cpu idle", "cpu user", "cpu nice", "cpu kernel", "cpu idle", "cpu user", "cpu nice", "cpu kernel", "cpu idle", "cpu user", "cpu nice", "cpu kernel", "cpu idle", "cpu user", "cpu nice", "cpu kernel", "cpu idle", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "reads issued", "reads merged", "reads sectors", "reads time in ms", "writes issued", "writes merged", "writes sectors", "writes time in ms", "io in progress", "io in ms", "average io in ms", "Total memory", "Used memory", "Free memory", "Shared", "Buffers", "Cached", "Total swap", "Used swap", "Free swap", "Pages in", "Pages out", "Swap in", "Swap out", "bytes received", "packets received", "errors received", "drop received", "fifo received", "frame received", "compressed received", "multicast", "bytes transmit", "packets transmit", "errors transmit", "drop transmit", "fifo transmit", "collisions", "carrier", "compressed transmit", "bytes received", "packets received", "errors received", "drop received", "fifo received", "frame received", "compressed received", "multicast", "bytes transmit", "packets transmit", "errors transmit", "drop transmit", "fifo transmit", "collisions", "carrier", "compressed transmit", "bytes received", "packets received", "errors received", "drop received", "fifo received", "frame received", "compressed received", "multicast", "bytes transmit", "packets transmit", "errors transmit", "drop transmit", "fifo transmit", "collisions", "carrier", "compressed transmit", "bytes received", "packets received", "errors received", "drop received", "fifo received", "frame received", "compressed received", "multicast", "bytes transmit", "packets transmit", "errors transmit", "drop transmit", "fifo transmit", "collisions", "carrier", "compressed transmit", "bytes received", "packets received", "errors received", "drop received", "fifo received", "frame received", "compressed received", "multicast", "bytes transmit", "packets transmit", "errors transmit", "drop transmit", "fifo transmit", "collisions", "carrier", "compressed transmit", "Interrupts", "Context switches", "Processes", "Controller total memory", "Controller used memory", "Controller Worker Pending Queue", "Controller Worker Threads Number", "Controller Idle Worker Threads", "Databases active threads", "Databases pending connections", "Databases number of threads", "Cache stats count hits", "Cache stats count insert", "Cache stats count select", "Cache stats hits percentage", "Cache stats number entries", "Scheduler number read", "Scheduler number requests", "Scheduler number writes", "Scheduler pending transactions", "Scheduler pending writes", "Databases active threads", "Databases pending connections", "Databases number of threads", "Cache stats count hits", "Cache stats count insert", "Cache stats count select", "Cache stats hits percentage", "Cache stats number entries", "Scheduler number read", "Scheduler number requests", "Scheduler number writes", "Scheduler pending transactions", "Scheduler pending writes"};
            this.scriptFile = new FileWriter(SCRIPT_FILE_NAME);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error while creating metadata-populator script file 'populate_lewys1.sql'");
        }
    }

    public void generate() {
        String sql = null;
        try {
            int i;
            this.scriptFile.write("connect lewys;\n\n\n");
            for (int i2 = 0; i2 < this.probeClasses.length; ++i2) {
                sql = "insert into probe_classes(name) values('" + this.probeClasses[i2] + "');\n";
                this.scriptFile.write(sql);
            }
            this.scriptFile.write("\n\n\n");
            int probeClass = 1;
            int firstProbeType = 1;
            for (int i3 = 0; i3 < this.probeTypes.length; ++i3) {
                sql = "insert into probe_types(name,probe_class) values('" + this.probeTypes[i3] + "'," + probeClass + ");\n";
                this.scriptFile.write(sql);
                if (i3 - firstProbeType + 2 != this.probeTypesCountPerProbeClass[probeClass - 1]) continue;
                ++probeClass;
                firstProbeType = i3 + 2;
            }
            this.scriptFile.write("\n\n\n");
            int probeType = 1;
            int firstResourceType = 1;
            for (i = 0; i < this.resourceTypes.length; ++i) {
                sql = "insert into resource_types(name,probe_type) values('" + this.resourceTypes[i] + "'," + probeType + ");\n";
                this.scriptFile.write(sql);
                if (i - firstResourceType + 2 != this.resourceTypesCountPerProbeType[probeType - 1]) continue;
                this.scriptFile.write("\n");
                ++probeType;
                firstResourceType = i + 2;
            }
            this.scriptFile.write("\n\n");
            for (i = 0; i < this.nodes.length; ++i) {
                sql = "insert into nodes(name,ip) values('" + this.nodes[i] + "','" + this.nodeIPs[i] + "');\n";
                this.scriptFile.write(sql);
            }
            this.scriptFile.write("\n\n\n");
            for (i = 0; i < this.nodes.length; ++i) {
                sql = "insert into pumps(name,node) values('" + this.nodes[i] + "'," + (i + 1) + ");\n";
                this.scriptFile.write(sql);
            }
            this.scriptFile.write("\n\n\n");
            for (i = 0; i < this.nodes.length; ++i) {
                for (int j = 0; j < this.probes.length; ++j) {
                    sql = "insert into probes(name,pump,probe_type) values('" + this.probes[j] + "'," + (i + 1) + "," + (j + 1) + ");\n";
                    this.scriptFile.write(sql);
                }
                this.scriptFile.write("\n");
            }
            this.scriptFile.write("\n\n");
            for (i = 0; i < this.nodes.length; ++i) {
                int resourceType = 0;
                for (int j = 0; j < this.probeTypes.length; ++j) {
                    for (int k = 0; k < this.resourceTypesCountPerProbeType[j]; ++k) {
                        int probe = i * this.probeTypes.length + j + 1;
                        sql = "insert into probe_resources(probe,resource_type,resource_id,probed_node) values(" + probe + "," + ++resourceType + "," + k + "," + (i + 1) + ");\n";
                        this.scriptFile.write(sql);
                    }
                    this.scriptFile.write("\n");
                }
                this.scriptFile.write("\n\n");
            }
            this.scriptFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error while writing to metadata-populator script file 'populate_lewys1.sql'");
        }
    }

    public static void main(String[] args) {
        try {
            PopulatorScriptGenerator generator = new PopulatorScriptGenerator();
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

