/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.systat;

import org.objectweb.lewys.common.log.Trace;
import org.objectweb.lewys.probe.Probe;

public class ProbingThread
extends Thread {
    private Probe[] probes;
    private int samplingPeriod;
    private int nbOfSamples;
    private static Trace logger = Trace.getLogger("org.objectweb.lewys.systat");
    private Trace[] loggers;
    private static char SEPARATOR = (char)9;

    public ProbingThread(Probe[] probes, int samplingPeriod, int nbOfSamples) {
        super("LeWYS probing thread");
        this.probes = probes;
        this.samplingPeriod = samplingPeriod;
        this.nbOfSamples = nbOfSamples;
        logger.info("Creating loggers for Probes");
        this.loggers = new Trace[probes.length];
        for (int i = 0; i < probes.length; ++i) {
            Probe probe = probes[i];
            this.loggers[i] = Trace.getLogger(probe.getClass().getName());
            if (!this.loggers[i].isDebugEnabled()) continue;
            String[] resources = probe.getResourceNames();
            for (int j = 0; j < resources.length; ++j) {
                this.loggers[i].debug("Resource " + j + ": " + resources[j]);
            }
        }
    }

    public void run() {
        boolean infiniteSampling = this.nbOfSamples == 0;
        long[][] values = new long[this.probes.length][];
        logger.info("Starting probing " + (this.nbOfSamples == 0 ? "continuously " : this.nbOfSamples + " samples of ") + this.probes.length + " probes every " + this.samplingPeriod + " ms.");
        while (infiniteSampling || this.nbOfSamples > 0) {
            long sleepTime;
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.probes.length; ++i) {
                Probe probe = this.probes[i];
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sampling probe " + probe.getClass());
                    }
                    values[i] = probe.getValue(probe.getResourceIds());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Logging samples of probe " + probe.getClass());
                    }
                    StringBuffer sampleString = new StringBuffer();
                    for (int j = 0; j < values[i].length; ++j) {
                        sampleString.append(values[i][j]);
                        sampleString.append(SEPARATOR);
                    }
                    this.loggers[i].info(sampleString.toString());
                    continue;
                }
                catch (Exception e) {
                    values[i] = null;
                    logger.error("Failed to sample probe " + probe.getClass(), e);
                }
            }
            long end = System.currentTimeMillis();
            if (!infiniteSampling) {
                --this.nbOfSamples;
            }
            if ((sleepTime = (long)this.samplingPeriod - (end - start)) <= 0L) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sleeping for " + sleepTime + " ms");
                }
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ignore) {}
        }
        logger.info("Probing finished.");
    }
}

